/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.async;

import java.util.concurrent.CompletionStage;
import org.neo4j.driver.AccessMode;
import org.neo4j.driver.internal.BoltServerAddress;
import org.neo4j.driver.internal.RoutingErrorHandler;
import org.neo4j.driver.internal.handlers.RoutingResponseHandler;
import org.neo4j.driver.internal.messaging.BoltProtocol;
import org.neo4j.driver.internal.messaging.Message;
import org.neo4j.driver.internal.spi.Connection;
import org.neo4j.driver.internal.spi.ResponseHandler;
import org.neo4j.driver.internal.util.ServerVersion;

public class RoutingConnection
implements Connection {
    private final Connection delegate;
    private final AccessMode accessMode;
    private final RoutingErrorHandler errorHandler;

    public RoutingConnection(Connection delegate, AccessMode accessMode, RoutingErrorHandler errorHandler) {
        this.delegate = delegate;
        this.accessMode = accessMode;
        this.errorHandler = errorHandler;
    }

    @Override
    public void enableAutoRead() {
        this.delegate.enableAutoRead();
    }

    @Override
    public void disableAutoRead() {
        this.delegate.disableAutoRead();
    }

    @Override
    public void write(Message message, ResponseHandler handler) {
        this.delegate.write(message, this.newRoutingResponseHandler(handler));
    }

    @Override
    public void write(Message message1, ResponseHandler handler1, Message message2, ResponseHandler handler2) {
        this.delegate.write(message1, this.newRoutingResponseHandler(handler1), message2, this.newRoutingResponseHandler(handler2));
    }

    @Override
    public void writeAndFlush(Message message, ResponseHandler handler) {
        this.delegate.writeAndFlush(message, this.newRoutingResponseHandler(handler));
    }

    @Override
    public void writeAndFlush(Message message1, ResponseHandler handler1, Message message2, ResponseHandler handler2) {
        this.delegate.writeAndFlush(message1, this.newRoutingResponseHandler(handler1), message2, this.newRoutingResponseHandler(handler2));
    }

    @Override
    public CompletionStage<Void> reset() {
        return this.delegate.reset();
    }

    @Override
    public boolean isOpen() {
        return this.delegate.isOpen();
    }

    @Override
    public CompletionStage<Void> release() {
        return this.delegate.release();
    }

    @Override
    public void terminateAndRelease(String reason) {
        this.delegate.terminateAndRelease(reason);
    }

    @Override
    public BoltServerAddress serverAddress() {
        return this.delegate.serverAddress();
    }

    @Override
    public ServerVersion serverVersion() {
        return this.delegate.serverVersion();
    }

    @Override
    public BoltProtocol protocol() {
        return this.delegate.protocol();
    }

    @Override
    public void flush() {
        this.delegate.flush();
    }

    private RoutingResponseHandler newRoutingResponseHandler(ResponseHandler handler) {
        return new RoutingResponseHandler(handler, this.serverAddress(), this.accessMode, this.errorHandler);
    }
}

