/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal;

import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.neo4j.driver.Driver;
import org.neo4j.driver.Logger;
import org.neo4j.driver.Logging;
import org.neo4j.driver.Metrics;
import org.neo4j.driver.Session;
import org.neo4j.driver.SessionParametersTemplate;
import org.neo4j.driver.async.AsyncSession;
import org.neo4j.driver.internal.NetworkSession;
import org.neo4j.driver.internal.SessionFactory;
import org.neo4j.driver.internal.SessionParameters;
import org.neo4j.driver.internal.metrics.MetricsProvider;
import org.neo4j.driver.internal.reactive.InternalRxSession;
import org.neo4j.driver.internal.security.SecurityPlan;
import org.neo4j.driver.internal.util.Futures;
import org.neo4j.driver.reactive.RxSession;

public class InternalDriver
implements Driver {
    private final SecurityPlan securityPlan;
    private final SessionFactory sessionFactory;
    private final Logger log;
    private AtomicBoolean closed = new AtomicBoolean(false);
    private final MetricsProvider metricsProvider;

    InternalDriver(SecurityPlan securityPlan, SessionFactory sessionFactory, MetricsProvider metricsProvider, Logging logging) {
        this.securityPlan = securityPlan;
        this.sessionFactory = sessionFactory;
        this.metricsProvider = metricsProvider;
        this.log = logging.getLog(Driver.class.getSimpleName());
    }

    @Override
    public Session session() {
        return this.newSession(SessionParameters.empty());
    }

    @Override
    public Session session(Consumer<SessionParametersTemplate> templateConsumer) {
        SessionParameters.Template template = SessionParameters.template();
        templateConsumer.accept(template);
        return this.newSession(template.build());
    }

    @Override
    public RxSession rxSession() {
        return new InternalRxSession(this.newSession(SessionParameters.empty()));
    }

    @Override
    public RxSession rxSession(Consumer<SessionParametersTemplate> templateConsumer) {
        SessionParameters.Template template = SessionParameters.template();
        templateConsumer.accept(template);
        return new InternalRxSession(this.newSession(template.build()));
    }

    @Override
    public AsyncSession asyncSession() {
        return this.newSession(SessionParameters.empty());
    }

    @Override
    public AsyncSession asyncSession(Consumer<SessionParametersTemplate> templateConsumer) {
        SessionParameters.Template template = SessionParameters.template();
        templateConsumer.accept(template);
        return this.newSession(template.build());
    }

    @Override
    public Metrics metrics() {
        return this.metricsProvider.metrics();
    }

    @Override
    public boolean isEncrypted() {
        this.assertOpen();
        return this.securityPlan.requiresEncryption();
    }

    @Override
    public void close() {
        Futures.blockingGet(this.closeAsync());
    }

    @Override
    public CompletionStage<Void> closeAsync() {
        if (this.closed.compareAndSet(false, true)) {
            this.log.info("Closing driver instance %s", this.hashCode());
            return this.sessionFactory.close();
        }
        return Futures.completedWithNull();
    }

    public CompletionStage<Void> verifyConnectivity() {
        return this.sessionFactory.verifyConnectivity();
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    private static RuntimeException driverCloseException() {
        return new IllegalStateException("This driver instance has already been closed");
    }

    private NetworkSession newSession(SessionParameters parameters) {
        this.assertOpen();
        NetworkSession session = this.sessionFactory.newInstance(parameters);
        if (this.closed.get()) {
            throw InternalDriver.driverCloseException();
        }
        return session;
    }

    private void assertOpen() {
        if (this.closed.get()) {
            throw InternalDriver.driverCloseException();
        }
    }
}

