/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.handlers;

import java.util.Map;
import org.neo4j.driver.internal.async.ChannelAttributes;
import org.neo4j.driver.internal.shaded.io.netty.channel.Channel;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelPromise;
import org.neo4j.driver.internal.shaded.io.netty.util.concurrent.Future;
import org.neo4j.driver.internal.shaded.io.netty.util.concurrent.GenericFutureListener;
import org.neo4j.driver.internal.spi.ResponseHandler;
import org.neo4j.driver.internal.util.ServerVersion;
import org.neo4j.driver.v1.Value;

public class HelloResponseHandler
implements ResponseHandler {
    private final ChannelPromise connectionInitializedPromise;
    private final Channel channel;

    public HelloResponseHandler(ChannelPromise connectionInitializedPromise) {
        this.connectionInitializedPromise = connectionInitializedPromise;
        this.channel = connectionInitializedPromise.channel();
    }

    @Override
    public void onSuccess(Map<String, Value> metadata) {
        try {
            ServerVersion serverVersion = HelloResponseHandler.extractServerVersion(metadata);
            ChannelAttributes.setServerVersion(this.channel, serverVersion);
            this.connectionInitializedPromise.setSuccess();
        }
        catch (Throwable error) {
            this.onFailure(error);
            throw error;
        }
    }

    @Override
    public void onFailure(Throwable error) {
        this.channel.close().addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)future -> this.connectionInitializedPromise.setFailure(error)));
    }

    @Override
    public void onRecord(Value[] fields) {
        throw new UnsupportedOperationException();
    }

    private static ServerVersion extractServerVersion(Map<String, Value> metadata) {
        Value versionValue = metadata.get("server");
        if (versionValue == null || versionValue.isNull()) {
            throw new IllegalStateException("Unable to get server version from a response to HELLO message. Metadata: " + metadata);
        }
        return ServerVersion.version(versionValue.asString());
    }
}

