/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.messaging;

import java.util.Map;
import java.util.concurrent.CompletionStage;
import org.neo4j.driver.internal.Bookmarks;
import org.neo4j.driver.internal.ExplicitTransaction;
import org.neo4j.driver.internal.InternalStatementResultCursor;
import org.neo4j.driver.internal.async.ChannelAttributes;
import org.neo4j.driver.internal.messaging.MessageFormat;
import org.neo4j.driver.internal.messaging.v1.BoltProtocolV1;
import org.neo4j.driver.internal.messaging.v2.BoltProtocolV2;
import org.neo4j.driver.internal.messaging.v3.BoltProtocolV3;
import org.neo4j.driver.internal.shaded.io.netty.channel.Channel;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelPromise;
import org.neo4j.driver.internal.spi.Connection;
import org.neo4j.driver.v1.Statement;
import org.neo4j.driver.v1.TransactionConfig;
import org.neo4j.driver.v1.Value;
import org.neo4j.driver.v1.exceptions.ClientException;

public interface BoltProtocol {
    public MessageFormat createMessageFormat();

    public void initializeChannel(String var1, Map<String, Value> var2, ChannelPromise var3);

    public CompletionStage<Void> beginTransaction(Connection var1, Bookmarks var2, TransactionConfig var3);

    public CompletionStage<Bookmarks> commitTransaction(Connection var1);

    public CompletionStage<Void> rollbackTransaction(Connection var1);

    public CompletionStage<InternalStatementResultCursor> runInAutoCommitTransaction(Connection var1, Statement var2, Bookmarks var3, TransactionConfig var4, boolean var5);

    public CompletionStage<InternalStatementResultCursor> runInExplicitTransaction(Connection var1, Statement var2, ExplicitTransaction var3, boolean var4);

    public static BoltProtocol forChannel(Channel channel) {
        return BoltProtocol.forVersion(ChannelAttributes.protocolVersion(channel));
    }

    public static BoltProtocol forVersion(int version) {
        switch (version) {
            case 1: {
                return BoltProtocolV1.INSTANCE;
            }
            case 2: {
                return BoltProtocolV2.INSTANCE;
            }
            case 3: {
                return BoltProtocolV3.INSTANCE;
            }
        }
        throw new ClientException("Unknown protocol version: " + version);
    }
}

