/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal;

import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.function.BiFunction;
import org.neo4j.driver.internal.AbstractStatementRunner;
import org.neo4j.driver.internal.Bookmarks;
import org.neo4j.driver.internal.InternalStatementResult;
import org.neo4j.driver.internal.InternalStatementResultCursor;
import org.neo4j.driver.internal.NetworkSession;
import org.neo4j.driver.internal.async.ResultCursorsHolder;
import org.neo4j.driver.internal.messaging.BoltProtocol;
import org.neo4j.driver.internal.spi.Connection;
import org.neo4j.driver.internal.util.Futures;
import org.neo4j.driver.v1.Statement;
import org.neo4j.driver.v1.StatementResult;
import org.neo4j.driver.v1.StatementResultCursor;
import org.neo4j.driver.v1.Transaction;
import org.neo4j.driver.v1.TransactionConfig;
import org.neo4j.driver.v1.exceptions.ClientException;

public class ExplicitTransaction
extends AbstractStatementRunner
implements Transaction {
    private final Connection connection;
    private final BoltProtocol protocol;
    private final NetworkSession session;
    private final ResultCursorsHolder resultCursors;
    private volatile Bookmarks bookmarks = Bookmarks.empty();
    private volatile State state = State.ACTIVE;

    public ExplicitTransaction(Connection connection, NetworkSession session) {
        this.connection = connection;
        this.protocol = connection.protocol();
        this.session = session;
        this.resultCursors = new ResultCursorsHolder();
    }

    public CompletionStage<ExplicitTransaction> beginAsync(Bookmarks initialBookmarks, TransactionConfig config) {
        return this.protocol.beginTransaction(this.connection, initialBookmarks, config).handle((ignore, beginError) -> {
            if (beginError != null) {
                this.connection.release();
                throw Futures.asCompletionException(beginError);
            }
            return this;
        });
    }

    @Override
    public void success() {
        if (this.state == State.ACTIVE) {
            this.state = State.MARKED_SUCCESS;
        }
    }

    @Override
    public void failure() {
        if (this.state == State.ACTIVE || this.state == State.MARKED_SUCCESS) {
            this.state = State.MARKED_FAILED;
        }
    }

    @Override
    public void close() {
        Futures.blockingGet(this.closeAsync(), () -> this.terminateConnectionOnThreadInterrupt("Thread interrupted while closing the transaction"));
    }

    CompletionStage<Void> closeAsync() {
        if (this.state == State.MARKED_SUCCESS) {
            return this.commitAsync();
        }
        if (this.state != State.COMMITTED && this.state != State.ROLLED_BACK) {
            return this.rollbackAsync();
        }
        return Futures.completedWithNull();
    }

    @Override
    public CompletionStage<Void> commitAsync() {
        if (this.state == State.COMMITTED) {
            return Futures.completedWithNull();
        }
        if (this.state == State.ROLLED_BACK) {
            return Futures.failedFuture(new ClientException("Can't commit, transaction has been rolled back"));
        }
        return this.resultCursors.retrieveNotConsumedError().thenCompose(error -> this.doCommitAsync().handle(ExplicitTransaction.handleCommitOrRollback(error))).whenComplete((ignore, error) -> this.transactionClosed(State.COMMITTED));
    }

    @Override
    public CompletionStage<Void> rollbackAsync() {
        if (this.state == State.COMMITTED) {
            return Futures.failedFuture(new ClientException("Can't rollback, transaction has been committed"));
        }
        if (this.state == State.ROLLED_BACK) {
            return Futures.completedWithNull();
        }
        return this.resultCursors.retrieveNotConsumedError().thenCompose(error -> this.doRollbackAsync().handle(ExplicitTransaction.handleCommitOrRollback(error))).whenComplete((ignore, error) -> this.transactionClosed(State.ROLLED_BACK));
    }

    @Override
    public StatementResult run(Statement statement) {
        StatementResultCursor cursor = Futures.blockingGet(this.run(statement, false), () -> this.terminateConnectionOnThreadInterrupt("Thread interrupted while running query in transaction"));
        return new InternalStatementResult(this.connection, cursor);
    }

    @Override
    public CompletionStage<StatementResultCursor> runAsync(Statement statement) {
        return this.run(statement, true);
    }

    private CompletionStage<InternalStatementResultCursor> run(Statement statement, boolean waitForRunResponse) {
        this.ensureCanRunQueries();
        CompletionStage<InternalStatementResultCursor> cursorStage = this.protocol.runInExplicitTransaction(this.connection, statement, this, waitForRunResponse);
        this.resultCursors.add(cursorStage);
        return cursorStage;
    }

    private void ensureCanRunQueries() {
        if (this.state == State.COMMITTED) {
            throw new ClientException("Cannot run more statements in this transaction, it has been committed");
        }
        if (this.state == State.ROLLED_BACK) {
            throw new ClientException("Cannot run more statements in this transaction, it has been rolled back");
        }
        if (this.state == State.MARKED_FAILED) {
            throw new ClientException("Cannot run more statements in this transaction, it has been marked for failure. Please either rollback or close this transaction");
        }
        if (this.state == State.TERMINATED) {
            throw new ClientException("Cannot run more statements in this transaction, it has either experienced an fatal error or was explicitly terminated");
        }
    }

    @Override
    public boolean isOpen() {
        return this.state != State.COMMITTED && this.state != State.ROLLED_BACK;
    }

    public void markTerminated() {
        this.state = State.TERMINATED;
    }

    public Bookmarks bookmark() {
        return this.bookmarks;
    }

    public void setBookmarks(Bookmarks bookmarks) {
        if (bookmarks != null && !bookmarks.isEmpty()) {
            this.bookmarks = bookmarks;
        }
    }

    private CompletionStage<Void> doCommitAsync() {
        if (this.state == State.TERMINATED) {
            return Futures.failedFuture(new ClientException("Transaction can't be committed. It has been rolled back either because of an error or explicit termination"));
        }
        return this.protocol.commitTransaction(this.connection).thenApply(newBookmarks -> {
            this.setBookmarks((Bookmarks)newBookmarks);
            return null;
        });
    }

    private CompletionStage<Void> doRollbackAsync() {
        if (this.state == State.TERMINATED) {
            return Futures.completedWithNull();
        }
        return this.protocol.rollbackTransaction(this.connection);
    }

    private static BiFunction<Void, Throwable, Void> handleCommitOrRollback(Throwable cursorFailure) {
        return (ignore, commitOrRollbackError) -> {
            CompletionException combinedError = Futures.combineErrors(cursorFailure, commitOrRollbackError);
            if (combinedError != null) {
                throw combinedError;
            }
            return null;
        };
    }

    private void transactionClosed(State newState) {
        this.state = newState;
        this.connection.release();
        this.session.setBookmarks(this.bookmarks);
    }

    private void terminateConnectionOnThreadInterrupt(String reason) {
        this.connection.terminateAndRelease(reason);
    }

    private static enum State {
        ACTIVE,
        MARKED_SUCCESS,
        MARKED_FAILED,
        TERMINATED,
        COMMITTED,
        ROLLED_BACK;

    }
}

