/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.async.inbound;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import org.neo4j.driver.internal.handlers.AckFailureResponseHandler;
import org.neo4j.driver.internal.logging.ChannelActivityLogger;
import org.neo4j.driver.internal.messaging.AckFailureMessage;
import org.neo4j.driver.internal.messaging.MessageHandler;
import org.neo4j.driver.internal.shaded.io.netty.channel.Channel;
import org.neo4j.driver.internal.spi.ResponseHandler;
import org.neo4j.driver.internal.util.ErrorUtil;
import org.neo4j.driver.v1.Logger;
import org.neo4j.driver.v1.Logging;
import org.neo4j.driver.v1.Value;
import org.neo4j.driver.v1.exceptions.ClientException;

public class InboundMessageDispatcher
implements MessageHandler {
    private final Channel channel;
    private final Queue<ResponseHandler> handlers = new LinkedList<ResponseHandler>();
    private final Logger log;
    private Throwable currentError;
    private boolean fatalErrorOccurred;
    private boolean ackFailureMuted;

    public InboundMessageDispatcher(Channel channel, Logging logging) {
        this.channel = Objects.requireNonNull(channel);
        this.log = new ChannelActivityLogger(channel, logging, this.getClass());
    }

    public void queue(ResponseHandler handler) {
        if (this.fatalErrorOccurred) {
            handler.onFailure(this.currentError);
        } else {
            this.handlers.add(handler);
        }
    }

    public int queuedHandlersCount() {
        return this.handlers.size();
    }

    @Override
    public void handleInitMessage(String clientNameAndVersion, Map<String, Value> authToken) {
        throw new UnsupportedOperationException("Driver is not supposed to receive INIT message. Received INIT with client: '" + clientNameAndVersion + "' and auth: " + authToken);
    }

    @Override
    public void handleRunMessage(String statement, Map<String, Value> parameters) {
        throw new UnsupportedOperationException("Driver is not supposed to receive RUN message. Received RUN with statement: '" + statement + "' and params: " + parameters);
    }

    @Override
    public void handlePullAllMessage() {
        throw new UnsupportedOperationException("Driver is not supposed to receive PULL_ALL message.");
    }

    @Override
    public void handleDiscardAllMessage() {
        throw new UnsupportedOperationException("Driver is not supposed to receive DISCARD_ALL message.");
    }

    @Override
    public void handleResetMessage() {
        throw new UnsupportedOperationException("Driver is not supposed to receive RESET message.");
    }

    @Override
    public void handleAckFailureMessage() {
        throw new UnsupportedOperationException("Driver is not supposed to receive ACK_FAILURE message.");
    }

    @Override
    public void handleSuccessMessage(Map<String, Value> meta) {
        this.log.debug("S: SUCCESS %s", meta);
        ResponseHandler handler = this.handlers.remove();
        handler.onSuccess(meta);
    }

    @Override
    public void handleRecordMessage(Value[] fields) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("S: RECORD %s", Arrays.toString(fields));
        }
        ResponseHandler handler = this.handlers.peek();
        handler.onRecord(fields);
    }

    @Override
    public void handleFailureMessage(String code, String message) {
        this.log.debug("S: FAILURE %s \"%s\"", code, message);
        this.currentError = ErrorUtil.newNeo4jError(code, message);
        if (ErrorUtil.isFatal(this.currentError)) {
            this.channel.pipeline().fireExceptionCaught(this.currentError);
            return;
        }
        this.ackFailureIfNeeded();
        ResponseHandler handler = this.handlers.remove();
        handler.onFailure(this.currentError);
    }

    @Override
    public void handleIgnoredMessage() {
        Throwable error;
        this.log.debug("S: IGNORED", new Object[0]);
        ResponseHandler handler = this.handlers.remove();
        if (this.currentError != null) {
            error = this.currentError;
        } else if (this.ackFailureMuted) {
            error = new ClientException("Database ignored the request because session has been reset");
        } else {
            this.log.warn("Received IGNORED message for handler %s but error is missing and RESET is not in progress. Current handlers %s", handler, this.handlers);
            error = new ClientException("Database ignored the request");
        }
        handler.onFailure(error);
    }

    public void handleFatalError(Throwable error) {
        this.currentError = error;
        this.fatalErrorOccurred = true;
        while (!this.handlers.isEmpty()) {
            ResponseHandler handler = this.handlers.remove();
            handler.onFailure(this.currentError);
        }
    }

    public void clearCurrentError() {
        this.currentError = null;
    }

    public Throwable currentError() {
        return this.currentError;
    }

    public boolean fatalErrorOccurred() {
        return this.fatalErrorOccurred;
    }

    public void muteAckFailure() {
        this.ackFailureMuted = true;
    }

    public void unMuteAckFailure() {
        this.ackFailureMuted = false;
    }

    private void ackFailureIfNeeded() {
        if (!this.ackFailureMuted) {
            this.queue(new AckFailureResponseHandler(this));
            this.channel.writeAndFlush(AckFailureMessage.ACK_FAILURE, this.channel.voidPromise());
        }
    }
}

