/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.messaging;

import java.io.IOException;
import org.neo4j.driver.internal.InternalPoint2D;
import org.neo4j.driver.internal.InternalPoint3D;
import org.neo4j.driver.internal.messaging.MessageFormat;
import org.neo4j.driver.internal.messaging.PackStreamMessageFormatV1;
import org.neo4j.driver.internal.packstream.PackInput;
import org.neo4j.driver.internal.packstream.PackOutput;
import org.neo4j.driver.internal.types.TypeConstructor;
import org.neo4j.driver.internal.value.InternalValue;
import org.neo4j.driver.internal.value.Point2DValue;
import org.neo4j.driver.internal.value.Point3DValue;
import org.neo4j.driver.v1.Value;
import org.neo4j.driver.v1.types.Point2D;
import org.neo4j.driver.v1.types.Point3D;

public class PackStreamMessageFormatV2
extends PackStreamMessageFormatV1 {
    private static final byte POINT_2D_STRUCT_TYPE = 88;
    private static final byte POINT_3D_STRUCT_TYPE = 89;
    private static final int POINT_2D_STRUCT_SIZE = 3;
    private static final int POINT_3D_STRUCT_SIZE = 4;

    @Override
    public MessageFormat.Writer newWriter(PackOutput output, boolean byteArraySupportEnabled) {
        if (!byteArraySupportEnabled) {
            throw new IllegalArgumentException("Bolt V2 should support byte arrays");
        }
        return new WriterV2(output);
    }

    @Override
    public MessageFormat.Reader newReader(PackInput input) {
        return new ReaderV2(input);
    }

    private static class ReaderV2
    extends PackStreamMessageFormatV1.ReaderV1 {
        ReaderV2(PackInput input) {
            super(input);
        }

        @Override
        Value unpackStruct(long size, byte type) throws IOException {
            if (type == 88) {
                this.ensureCorrectStructSize(TypeConstructor.POINT_2D_TyCon.typeName(), 3, size);
                return this.unpackPoint2D();
            }
            if (type == 89) {
                this.ensureCorrectStructSize(TypeConstructor.POINT_3D_TyCon.typeName(), 4, size);
                return this.unpackPoint3D();
            }
            return super.unpackStruct(size, type);
        }

        private Value unpackPoint2D() throws IOException {
            long srid = this.unpacker.unpackLong();
            double x = this.unpacker.unpackDouble();
            double y = this.unpacker.unpackDouble();
            return new Point2DValue(new InternalPoint2D(srid, x, y));
        }

        private Value unpackPoint3D() throws IOException {
            long srid = this.unpacker.unpackLong();
            double x = this.unpacker.unpackDouble();
            double y = this.unpacker.unpackDouble();
            double z = this.unpacker.unpackDouble();
            return new Point3DValue(new InternalPoint3D(srid, x, y, z));
        }
    }

    private static class WriterV2
    extends PackStreamMessageFormatV1.WriterV1 {
        WriterV2(PackOutput output) {
            super(output, true);
        }

        @Override
        void packInternalValue(InternalValue value) throws IOException {
            if (value.typeConstructor() == TypeConstructor.POINT_2D_TyCon) {
                this.packPoint2D(value.asPoint2D());
            } else if (value.typeConstructor() == TypeConstructor.POINT_3D_TyCon) {
                this.packPoint3D(value.asPoint3D());
            } else {
                super.packInternalValue(value);
            }
        }

        private void packPoint2D(Point2D point) throws IOException {
            this.packer.packStructHeader(3, (byte)88);
            this.packer.pack(point.srid());
            this.packer.pack(point.x());
            this.packer.pack(point.y());
        }

        private void packPoint3D(Point3D point) throws IOException {
            this.packer.packStructHeader(4, (byte)89);
            this.packer.pack(point.srid());
            this.packer.pack(point.x());
            this.packer.pack(point.y());
            this.packer.pack(point.z());
        }
    }
}

