/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.async;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.neo4j.driver.internal.InternalStatementResultCursor;

public class ResultCursorsHolder {
    private final List<CompletionStage<InternalStatementResultCursor>> cursorStages = new ArrayList<CompletionStage<InternalStatementResultCursor>>();

    public void add(CompletionStage<InternalStatementResultCursor> cursorStage) {
        Objects.requireNonNull(cursorStage);
        this.cursorStages.add(cursorStage);
    }

    public CompletionStage<Throwable> retrieveNotConsumedError() {
        return this.cursorStages.stream().map(this::retrieveFailure).reduce(CompletableFuture.completedFuture(null), this::nonNullFailureFromEither);
    }

    private CompletionStage<Throwable> retrieveFailure(CompletionStage<InternalStatementResultCursor> cursorStage) {
        return cursorStage.exceptionally(cursor -> null).thenCompose(cursor -> cursor == null ? CompletableFuture.completedFuture(null) : cursor.failureAsync());
    }

    private CompletionStage<Throwable> nonNullFailureFromEither(CompletionStage<Throwable> stage1, CompletionStage<Throwable> stage2) {
        return stage1.thenCompose(value -> {
            if (value != null) {
                return CompletableFuture.completedFuture(value);
            }
            return stage2;
        });
    }
}

