/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.async.outbound;

import java.util.List;
import org.neo4j.driver.internal.async.ProtocolUtil;
import org.neo4j.driver.internal.async.outbound.ChunkAwareByteBufOutput;
import org.neo4j.driver.internal.messaging.Message;
import org.neo4j.driver.internal.messaging.MessageFormat;
import org.neo4j.driver.internal.shaded.io.netty.buffer.ByteBuf;
import org.neo4j.driver.internal.shaded.io.netty.buffer.ByteBufUtil;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelHandlerContext;
import org.neo4j.driver.internal.shaded.io.netty.handler.codec.EncoderException;
import org.neo4j.driver.internal.shaded.io.netty.handler.codec.MessageToMessageEncoder;
import org.neo4j.driver.v1.Logger;
import org.neo4j.driver.v1.Logging;

public class OutboundMessageHandler
extends MessageToMessageEncoder<Message> {
    public static final String NAME = OutboundMessageHandler.class.getSimpleName();
    private final MessageFormat messageFormat;
    private final ChunkAwareByteBufOutput output;
    private final MessageFormat.Writer writer;
    private final Logger log;

    public OutboundMessageHandler(MessageFormat messageFormat, Logging logging) {
        this(messageFormat, true, logging.getLog(NAME));
    }

    private OutboundMessageHandler(MessageFormat messageFormat, boolean byteArraySupportEnabled, Logger log) {
        this.messageFormat = messageFormat;
        this.output = new ChunkAwareByteBufOutput();
        this.writer = messageFormat.newWriter(this.output, byteArraySupportEnabled);
        this.log = log;
    }

    @Override
    protected void encode(ChannelHandlerContext ctx, Message msg, List<Object> out) {
        this.log.debug("Sending message %s", msg);
        ByteBuf messageBuf = ctx.alloc().ioBuffer();
        this.output.start(messageBuf);
        try {
            this.writer.write(msg);
            this.output.stop();
        }
        catch (Throwable error) {
            this.output.stop();
            messageBuf.release();
            throw new EncoderException("Failed to write outbound message: " + msg, error);
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("Message %s encoded as\n%s\n", msg, ByteBufUtil.prettyHexDump(messageBuf));
        }
        out.add(messageBuf);
        out.add(ProtocolUtil.messageBoundary());
    }

    public OutboundMessageHandler withoutByteArraySupport() {
        return new OutboundMessageHandler(this.messageFormat, false, this.log);
    }
}

