/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.async;

import org.neo4j.driver.internal.shaded.io.netty.bootstrap.Bootstrap;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelOption;
import org.neo4j.driver.internal.shaded.io.netty.channel.nio.NioEventLoopGroup;
import org.neo4j.driver.internal.shaded.io.netty.channel.socket.nio.NioSocketChannel;

public final class BootstrapFactory {
    private BootstrapFactory() {
    }

    public static Bootstrap newBootstrap() {
        return BootstrapFactory.newBootstrap(new NioEventLoopGroup());
    }

    public static Bootstrap newBootstrap(int threadCount) {
        return BootstrapFactory.newBootstrap(new NioEventLoopGroup(threadCount));
    }

    private static Bootstrap newBootstrap(NioEventLoopGroup eventLoopGroup) {
        Bootstrap bootstrap = new Bootstrap();
        bootstrap.group(eventLoopGroup);
        bootstrap.channel(NioSocketChannel.class);
        bootstrap.option(ChannelOption.SO_KEEPALIVE, true);
        bootstrap.option(ChannelOption.SO_REUSEADDR, true);
        return bootstrap;
    }
}

