/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicBoolean;
import org.neo4j.driver.internal.Bookmark;
import org.neo4j.driver.internal.ExplicitTransaction;
import org.neo4j.driver.internal.InternalStatementResult;
import org.neo4j.driver.internal.async.InternalStatementResultCursor;
import org.neo4j.driver.internal.async.QueryRunner;
import org.neo4j.driver.internal.logging.DelegatingLogger;
import org.neo4j.driver.internal.retry.RetryLogic;
import org.neo4j.driver.internal.spi.Connection;
import org.neo4j.driver.internal.spi.ConnectionProvider;
import org.neo4j.driver.internal.types.InternalTypeSystem;
import org.neo4j.driver.internal.util.Futures;
import org.neo4j.driver.v1.AccessMode;
import org.neo4j.driver.v1.Logger;
import org.neo4j.driver.v1.Logging;
import org.neo4j.driver.v1.Record;
import org.neo4j.driver.v1.Session;
import org.neo4j.driver.v1.Statement;
import org.neo4j.driver.v1.StatementResult;
import org.neo4j.driver.v1.StatementResultCursor;
import org.neo4j.driver.v1.Transaction;
import org.neo4j.driver.v1.TransactionWork;
import org.neo4j.driver.v1.Value;
import org.neo4j.driver.v1.Values;
import org.neo4j.driver.v1.exceptions.ClientException;
import org.neo4j.driver.v1.types.TypeSystem;

public class NetworkSession
implements Session {
    private static final String LOG_NAME = "Session";
    private final ConnectionProvider connectionProvider;
    private final AccessMode mode;
    private final RetryLogic retryLogic;
    protected final Logger logger;
    private volatile Bookmark bookmark = Bookmark.empty();
    private volatile CompletionStage<ExplicitTransaction> transactionStage = CompletableFuture.completedFuture(null);
    private volatile CompletionStage<Connection> connectionStage = CompletableFuture.completedFuture(null);
    private volatile CompletionStage<InternalStatementResultCursor> resultCursorStage = CompletableFuture.completedFuture(null);
    private final AtomicBoolean open = new AtomicBoolean(true);

    public NetworkSession(ConnectionProvider connectionProvider, AccessMode mode, RetryLogic retryLogic, Logging logging) {
        this.connectionProvider = connectionProvider;
        this.mode = mode;
        this.retryLogic = retryLogic;
        this.logger = new DelegatingLogger(logging.getLog(LOG_NAME), String.valueOf(this.hashCode()));
    }

    @Override
    public StatementResult run(String statementText) {
        return this.run(statementText, Values.EmptyMap);
    }

    @Override
    public CompletionStage<StatementResultCursor> runAsync(String statementText) {
        return this.runAsync(statementText, Values.EmptyMap);
    }

    @Override
    public StatementResult run(String statementText, Map<String, Object> statementParameters) {
        Value params = statementParameters == null ? Values.EmptyMap : Values.value(statementParameters);
        return this.run(statementText, params);
    }

    @Override
    public CompletionStage<StatementResultCursor> runAsync(String statementText, Map<String, Object> statementParameters) {
        Value params = statementParameters == null ? Values.EmptyMap : Values.value(statementParameters);
        return this.runAsync(statementText, params);
    }

    @Override
    public StatementResult run(String statementTemplate, Record statementParameters) {
        Value params = statementParameters == null ? Values.EmptyMap : Values.value(statementParameters.asMap());
        return this.run(statementTemplate, params);
    }

    @Override
    public CompletionStage<StatementResultCursor> runAsync(String statementTemplate, Record statementParameters) {
        Value params = statementParameters == null ? Values.EmptyMap : Values.value(statementParameters.asMap());
        return this.runAsync(statementTemplate, params);
    }

    @Override
    public StatementResult run(String statementText, Value statementParameters) {
        return this.run(new Statement(statementText, statementParameters));
    }

    @Override
    public CompletionStage<StatementResultCursor> runAsync(String statementText, Value parameters) {
        return this.runAsync(new Statement(statementText, parameters));
    }

    @Override
    public StatementResult run(Statement statement) {
        StatementResultCursor cursor = Futures.getBlocking(this.runAsync(statement, false));
        return new InternalStatementResult(cursor);
    }

    @Override
    public CompletionStage<StatementResultCursor> runAsync(Statement statement) {
        return this.runAsync(statement, true);
    }

    @Override
    public boolean isOpen() {
        return this.open.get();
    }

    @Override
    public void close() {
        Futures.getBlocking(this.closeAsync());
    }

    @Override
    public CompletionStage<Void> closeAsync() {
        if (this.open.compareAndSet(true, false)) {
            return this.resultCursorStage.thenCompose(cursor -> {
                if (cursor == null) {
                    return CompletableFuture.completedFuture(null);
                }
                return cursor.failureAsync();
            }).thenCompose(error -> this.releaseResources().thenApply(ignore -> {
                Throwable queryError = Futures.completionErrorCause(error);
                if (queryError != null) {
                    throw new CompletionException(queryError);
                }
                return null;
            }));
        }
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public Transaction beginTransaction() {
        return Futures.getBlocking(this.beginTransactionAsync(this.mode));
    }

    @Override
    @Deprecated
    public Transaction beginTransaction(String bookmark) {
        this.setBookmark(Bookmark.from(bookmark));
        return this.beginTransaction();
    }

    @Override
    public CompletionStage<Transaction> beginTransactionAsync() {
        return this.beginTransactionAsync(this.mode);
    }

    @Override
    public <T> T readTransaction(TransactionWork<T> work) {
        return this.transaction(AccessMode.READ, work);
    }

    @Override
    public <T> CompletionStage<T> readTransactionAsync(TransactionWork<CompletionStage<T>> work) {
        return this.transactionAsync(AccessMode.READ, work);
    }

    @Override
    public <T> T writeTransaction(TransactionWork<T> work) {
        return this.transaction(AccessMode.WRITE, work);
    }

    @Override
    public <T> CompletionStage<T> writeTransactionAsync(TransactionWork<CompletionStage<T>> work) {
        return this.transactionAsync(AccessMode.WRITE, work);
    }

    void setBookmark(Bookmark bookmark) {
        if (bookmark != null && !bookmark.isEmpty()) {
            this.bookmark = bookmark;
        }
    }

    @Override
    public String lastBookmark() {
        return this.bookmark == null ? null : this.bookmark.maxBookmarkAsString();
    }

    @Override
    public void reset() {
        Futures.getBlocking(this.resetAsync());
    }

    private CompletionStage<Void> resetAsync() {
        return this.existingTransactionOrNull().thenAccept(tx -> {
            if (tx != null) {
                tx.markTerminated();
            }
        }).thenCompose(ignore -> this.releaseConnection());
    }

    @Override
    public TypeSystem typeSystem() {
        return InternalTypeSystem.TYPE_SYSTEM;
    }

    CompletionStage<Boolean> currentConnectionIsOpen() {
        if (this.connectionStage == null) {
            return CompletableFuture.completedFuture(false);
        }
        return this.connectionStage.handle((connection, error) -> error == null && connection != null && connection.isOpen());
    }

    private <T> T transaction(AccessMode mode, TransactionWork<T> work) {
        return (T)this.retryLogic.retry(() -> {
            Throwable throwable = null;
            try (Transaction tx = Futures.getBlocking(this.beginTransactionAsync(mode));){
                Object result = work.execute(tx);
                tx.success();
                Object t = result;
                return t;
            }
            catch (Throwable t) {
                try {
                    tx.failure();
                    throw t;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
        });
    }

    private <T> CompletionStage<T> transactionAsync(AccessMode mode, TransactionWork<CompletionStage<T>> work) {
        return this.retryLogic.retryAsync(() -> {
            CompletableFuture resultFuture = new CompletableFuture();
            CompletionStage<ExplicitTransaction> txFuture = this.beginTransactionAsync(mode);
            txFuture.whenComplete((tx, completionError) -> {
                Throwable error = Futures.completionErrorCause(completionError);
                if (error != null) {
                    resultFuture.completeExceptionally(error);
                } else {
                    this.executeWork(resultFuture, (ExplicitTransaction)tx, work);
                }
            });
            return resultFuture;
        });
    }

    private <T> void executeWork(CompletableFuture<T> resultFuture, ExplicitTransaction tx, TransactionWork<CompletionStage<T>> work) {
        CompletionStage<Object> workFuture = this.safeExecuteWork(tx, work);
        workFuture.whenComplete((result, completionError) -> {
            Throwable error = Futures.completionErrorCause(completionError);
            if (error != null) {
                this.rollbackTxAfterFailedTransactionWork(tx, resultFuture, error);
            } else {
                this.closeTxAfterSucceededTransactionWork(tx, resultFuture, result);
            }
        });
    }

    private <T> CompletionStage<T> safeExecuteWork(ExplicitTransaction tx, TransactionWork<CompletionStage<T>> work) {
        try {
            return work.execute(tx);
        }
        catch (Throwable workError) {
            return Futures.failedFuture(workError);
        }
    }

    private <T> void rollbackTxAfterFailedTransactionWork(ExplicitTransaction tx, CompletableFuture<T> resultFuture, Throwable error) {
        if (tx.isOpen()) {
            tx.rollbackAsync().whenComplete((ignore, rollbackError) -> {
                if (rollbackError != null) {
                    error.addSuppressed((Throwable)rollbackError);
                }
                resultFuture.completeExceptionally(error);
            });
        } else {
            resultFuture.completeExceptionally(error);
        }
    }

    private <T> void closeTxAfterSucceededTransactionWork(ExplicitTransaction tx, CompletableFuture<T> resultFuture, T result) {
        if (tx.isOpen()) {
            tx.success();
            tx.closeAsync().whenComplete((ignore, completionError) -> {
                Throwable commitError = Futures.completionErrorCause(completionError);
                if (commitError != null) {
                    resultFuture.completeExceptionally(commitError);
                } else {
                    resultFuture.complete(result);
                }
            });
        } else {
            resultFuture.complete(result);
        }
    }

    private CompletionStage<InternalStatementResultCursor> runAsync(Statement statement, boolean waitForRunResponse) {
        this.ensureSessionIsOpen();
        CompletionStage<InternalStatementResultCursor> newResultCursorStage = this.ensureNoOpenTxBeforeRunningQuery().thenCompose(ignore -> this.acquireConnection(this.mode)).thenCompose(connection -> {
            if (waitForRunResponse) {
                return QueryRunner.runAsAsync(connection, statement);
            }
            return QueryRunner.runAsBlocking(connection, statement);
        });
        this.resultCursorStage = newResultCursorStage.exceptionally(error -> null);
        return newResultCursorStage;
    }

    private CompletionStage<ExplicitTransaction> beginTransactionAsync(AccessMode mode) {
        this.ensureSessionIsOpen();
        this.transactionStage = this.ensureNoOpenTxBeforeStartingTx().thenCompose(ignore -> this.acquireConnection(mode)).thenCompose(connection -> {
            ExplicitTransaction tx = new ExplicitTransaction((Connection)connection, this);
            return tx.beginAsync(this.bookmark);
        });
        return this.transactionStage;
    }

    private CompletionStage<Connection> acquireConnection(AccessMode mode) {
        CompletionStage<Connection> currentConnectionStage = this.connectionStage;
        CompletionStage<Connection> newConnectionStage = this.resultCursorStage.thenCompose(cursor -> {
            if (cursor == null) {
                return CompletableFuture.completedFuture(null);
            }
            return cursor.failureAsync();
        }).thenCompose(error -> {
            if (error == null) {
                return currentConnectionStage.exceptionally(ignore -> null);
            }
            throw new CompletionException((Throwable)error);
        }).thenCompose(existingConnection -> {
            if (existingConnection != null && existingConnection.isOpen()) {
                throw new IllegalStateException("Existing open connection detected");
            }
            return this.connectionProvider.acquireConnection(mode);
        });
        this.connectionStage = newConnectionStage.exceptionally(error -> null);
        return newConnectionStage;
    }

    private CompletionStage<Void> releaseResources() {
        return this.rollbackTransaction().thenCompose(ignore -> this.releaseConnection());
    }

    private CompletionStage<Void> rollbackTransaction() {
        return this.existingTransactionOrNull().thenCompose(tx -> {
            if (tx != null) {
                return tx.rollbackAsync();
            }
            return CompletableFuture.completedFuture(null);
        }).exceptionally(error -> {
            Throwable cause = Futures.completionErrorCause(error);
            this.logger.warn("Active transaction rolled back with an error", cause);
            return null;
        });
    }

    private CompletionStage<Void> releaseConnection() {
        return this.existingConnectionOrNull().thenCompose(connection -> {
            if (connection != null) {
                return connection.release();
            }
            return CompletableFuture.completedFuture(null);
        });
    }

    private CompletionStage<Void> ensureNoOpenTxBeforeRunningQuery() {
        return this.ensureNoOpenTx("Statements cannot be run directly on a session with an open transaction; either run from within the transaction or use a different session.");
    }

    private CompletionStage<Void> ensureNoOpenTxBeforeStartingTx() {
        return this.ensureNoOpenTx("You cannot begin a transaction on a session with an open transaction; either run from within the transaction or use a different session.");
    }

    private CompletionStage<Void> ensureNoOpenTx(String errorMessage) {
        return this.existingTransactionOrNull().thenAccept(tx -> {
            if (tx != null) {
                throw new ClientException(errorMessage);
            }
        });
    }

    private CompletionStage<ExplicitTransaction> existingTransactionOrNull() {
        return this.transactionStage.exceptionally(error -> null).thenApply(tx -> tx != null && tx.isOpen() ? tx : null);
    }

    private CompletionStage<Connection> existingConnectionOrNull() {
        return this.connectionStage.exceptionally(error -> null);
    }

    private void ensureSessionIsOpen() {
        if (!this.open.get()) {
            throw new ClientException("No more interaction with this session are allowed as the current session is already closed. ");
        }
    }
}

