/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicBoolean;
import org.neo4j.driver.internal.Bookmark;
import org.neo4j.driver.internal.SessionFactory;
import org.neo4j.driver.internal.security.SecurityPlan;
import org.neo4j.driver.internal.util.Futures;
import org.neo4j.driver.v1.AccessMode;
import org.neo4j.driver.v1.Driver;
import org.neo4j.driver.v1.Session;

public class InternalDriver
implements Driver {
    private final SecurityPlan securityPlan;
    private final SessionFactory sessionFactory;
    private AtomicBoolean closed = new AtomicBoolean(false);

    InternalDriver(SecurityPlan securityPlan, SessionFactory sessionFactory) {
        this.securityPlan = securityPlan;
        this.sessionFactory = sessionFactory;
    }

    @Override
    public boolean isEncrypted() {
        this.assertOpen();
        return this.securityPlan.requiresEncryption();
    }

    @Override
    public Session session() {
        return this.session(AccessMode.WRITE);
    }

    @Override
    public Session session(AccessMode mode) {
        return this.newSession(mode, Bookmark.empty());
    }

    @Override
    public Session session(String bookmark) {
        return this.session(AccessMode.WRITE, bookmark);
    }

    @Override
    public Session session(AccessMode mode, String bookmark) {
        return this.newSession(mode, Bookmark.from(bookmark));
    }

    @Override
    public Session session(Iterable<String> bookmarks) {
        return this.session(AccessMode.WRITE, bookmarks);
    }

    @Override
    public Session session(AccessMode mode, Iterable<String> bookmarks) {
        return this.newSession(mode, Bookmark.from(bookmarks));
    }

    private Session newSession(AccessMode mode, Bookmark bookmark) {
        this.assertOpen();
        Session session = this.sessionFactory.newInstance(mode, bookmark);
        if (this.closed.get()) {
            throw InternalDriver.driverCloseException();
        }
        return session;
    }

    @Override
    public void close() {
        Futures.getBlocking(this.closeAsync());
    }

    @Override
    public CompletionStage<Void> closeAsync() {
        if (this.closed.compareAndSet(false, true)) {
            return this.sessionFactory.close();
        }
        return CompletableFuture.completedFuture(null);
    }

    public CompletionStage<Void> verifyConnectivity() {
        return this.sessionFactory.verifyConnectivity();
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    private void assertOpen() {
        if (this.closed.get()) {
            throw InternalDriver.driverCloseException();
        }
    }

    private static RuntimeException driverCloseException() {
        return new IllegalStateException("This driver instance has already been closed");
    }
}

