/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.security;

import java.io.File;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.neo4j.driver.internal.async.BoltServerAddress;
import org.neo4j.driver.internal.security.TrustAllTrustManager;
import org.neo4j.driver.internal.security.TrustOnFirstUseTrustManager;
import org.neo4j.driver.internal.util.CertificateTool;
import org.neo4j.driver.v1.Logger;

public class SecurityPlan {
    private final boolean requiresEncryption;
    private final SSLContext sslContext;
    private final boolean routingCompatible;

    public static SecurityPlan forAllCertificates() throws GeneralSecurityException, IOException {
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(new KeyManager[0], new TrustManager[]{new TrustAllTrustManager()}, null);
        return new SecurityPlan(true, sslContext, true);
    }

    public static SecurityPlan forCustomCASignedCertificates(File certFile) throws GeneralSecurityException, IOException {
        KeyStore trustedKeyStore = KeyStore.getInstance("JKS");
        trustedKeyStore.load(null, null);
        CertificateTool.loadX509Cert(certFile, trustedKeyStore);
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance("SunX509");
        trustManagerFactory.init(trustedKeyStore);
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(new KeyManager[0], trustManagerFactory.getTrustManagers(), null);
        return new SecurityPlan(true, sslContext, true);
    }

    public static SecurityPlan forSystemCASignedCertificates() throws NoSuchAlgorithmException, KeyStoreException {
        return new SecurityPlan(true, SSLContext.getDefault(), true);
    }

    @Deprecated
    public static SecurityPlan forTrustOnFirstUse(File knownHosts, BoltServerAddress address, Logger logger) throws IOException, KeyManagementException, NoSuchAlgorithmException {
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(new KeyManager[0], new TrustManager[]{new TrustOnFirstUseTrustManager(address, knownHosts, logger)}, null);
        return new SecurityPlan(true, sslContext, false);
    }

    public static SecurityPlan insecure() {
        return new SecurityPlan(false, null, true);
    }

    private SecurityPlan(boolean requiresEncryption, SSLContext sslContext, boolean routingCompatible) {
        this.requiresEncryption = requiresEncryption;
        this.sslContext = sslContext;
        this.routingCompatible = routingCompatible;
    }

    public boolean requiresEncryption() {
        return this.requiresEncryption;
    }

    public boolean isRoutingCompatible() {
        return this.routingCompatible;
    }

    public SSLContext sslContext() {
        return this.sslContext;
    }
}

