/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.async.inbound;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.DecoderException;
import java.util.Objects;
import org.neo4j.driver.internal.async.ChannelAttributes;
import org.neo4j.driver.internal.async.inbound.ByteBufInput;
import org.neo4j.driver.internal.async.inbound.InboundMessageDispatcher;
import org.neo4j.driver.internal.messaging.MessageFormat;
import org.neo4j.driver.v1.Logger;
import org.neo4j.driver.v1.Logging;

public class InboundMessageHandler
extends SimpleChannelInboundHandler<ByteBuf> {
    private final ByteBufInput input = new ByteBufInput();
    private final MessageFormat.Reader reader;
    private final Logger log;
    private InboundMessageDispatcher messageDispatcher;

    public InboundMessageHandler(MessageFormat messageFormat, Logging logging) {
        this.reader = messageFormat.newReader(this.input);
        this.log = logging.getLog(((Object)((Object)this)).getClass().getSimpleName());
    }

    public void handlerAdded(ChannelHandlerContext ctx) {
        this.messageDispatcher = Objects.requireNonNull(ChannelAttributes.messageDispatcher(ctx.channel()));
    }

    public void handlerRemoved(ChannelHandlerContext ctx) {
        this.messageDispatcher = null;
    }

    protected void channelRead0(ChannelHandlerContext ctx, ByteBuf msg) {
        if (this.messageDispatcher.fatalErrorOccurred()) {
            this.log.warn("Message ignored because of the previous fatal error. Channel will be closed. Message:\n%s\n", ByteBufUtil.prettyHexDump((ByteBuf)msg));
            return;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("Inbound message received:\n%s\n", ByteBufUtil.prettyHexDump((ByteBuf)msg));
        }
        this.input.start(msg);
        try {
            this.reader.read(this.messageDispatcher);
        }
        catch (Throwable error) {
            throw new DecoderException("Failed to read inbound message:\n" + ByteBufUtil.prettyHexDump((ByteBuf)msg) + "\n", error);
        }
        finally {
            this.input.stop();
        }
    }
}

