/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.handlers;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.neo4j.driver.internal.InternalRecord;
import org.neo4j.driver.internal.handlers.RunResponseHandler;
import org.neo4j.driver.internal.spi.ResponseHandler;
import org.neo4j.driver.internal.summary.InternalNotification;
import org.neo4j.driver.internal.summary.InternalPlan;
import org.neo4j.driver.internal.summary.InternalProfiledPlan;
import org.neo4j.driver.internal.summary.InternalSummaryCounters;
import org.neo4j.driver.v1.Record;
import org.neo4j.driver.v1.Value;
import org.neo4j.driver.v1.summary.Notification;
import org.neo4j.driver.v1.summary.Plan;
import org.neo4j.driver.v1.summary.ProfiledPlan;
import org.neo4j.driver.v1.summary.StatementType;
import org.neo4j.driver.v1.summary.SummaryCounters;

public class RecordsResponseHandler
implements ResponseHandler {
    private final RunResponseHandler runResponseHandler;
    private final Queue<Record> recordBuffer;
    private StatementType statementType;
    private SummaryCounters counters;
    private Plan plan;
    private ProfiledPlan profile;
    private List<Notification> notifications;
    private long resultConsumedAfter;
    private boolean completed;

    public RecordsResponseHandler(RunResponseHandler runResponseHandler) {
        this.runResponseHandler = runResponseHandler;
        this.recordBuffer = new ConcurrentLinkedQueue<Record>();
    }

    @Override
    public void onSuccess(Map<String, Value> metadata) {
        this.statementType = RecordsResponseHandler.extractStatementType(metadata);
        this.counters = RecordsResponseHandler.extractCounters(metadata);
        this.plan = RecordsResponseHandler.extractPlan(metadata);
        this.profile = RecordsResponseHandler.extractProfiledPlan(metadata);
        this.notifications = RecordsResponseHandler.extractNotifications(metadata);
        this.resultConsumedAfter = RecordsResponseHandler.extractResultConsumedAfter(metadata);
        this.completed = true;
    }

    @Override
    public void onFailure(Throwable error) {
        this.completed = true;
    }

    @Override
    public void onRecord(Value[] fields) {
        this.recordBuffer.add(new InternalRecord(this.runResponseHandler.statementKeys(), fields));
    }

    public Queue<Record> recordBuffer() {
        return this.recordBuffer;
    }

    public StatementType statementType() {
        return this.statementType;
    }

    public SummaryCounters counters() {
        return this.counters;
    }

    public Plan plan() {
        return this.plan;
    }

    public ProfiledPlan profile() {
        return this.profile;
    }

    public List<Notification> notifications() {
        return this.notifications;
    }

    public long resultConsumedAfter() {
        return this.resultConsumedAfter;
    }

    public boolean isCompleted() {
        return this.completed;
    }

    private static StatementType extractStatementType(Map<String, Value> metadata) {
        Value typeValue = metadata.get("type");
        if (typeValue != null) {
            return StatementType.fromCode(typeValue.asString());
        }
        return null;
    }

    private static InternalSummaryCounters extractCounters(Map<String, Value> metadata) {
        Value countersValue = metadata.get("stats");
        if (countersValue != null) {
            return new InternalSummaryCounters(RecordsResponseHandler.counterValue(countersValue, "nodes-created"), RecordsResponseHandler.counterValue(countersValue, "nodes-deleted"), RecordsResponseHandler.counterValue(countersValue, "relationships-created"), RecordsResponseHandler.counterValue(countersValue, "relationships-deleted"), RecordsResponseHandler.counterValue(countersValue, "properties-set"), RecordsResponseHandler.counterValue(countersValue, "labels-added"), RecordsResponseHandler.counterValue(countersValue, "labels-removed"), RecordsResponseHandler.counterValue(countersValue, "indexes-added"), RecordsResponseHandler.counterValue(countersValue, "indexes-removed"), RecordsResponseHandler.counterValue(countersValue, "constraints-added"), RecordsResponseHandler.counterValue(countersValue, "constraints-removed"));
        }
        return null;
    }

    private static int counterValue(Value countersValue, String name) {
        Value value = countersValue.get(name);
        return value.isNull() ? 0 : value.asInt();
    }

    private static Plan extractPlan(Map<String, Value> metadata) {
        Value planValue = metadata.get("plan");
        if (planValue != null) {
            return InternalPlan.EXPLAIN_PLAN_FROM_VALUE.apply(planValue);
        }
        return null;
    }

    private static ProfiledPlan extractProfiledPlan(Map<String, Value> metadata) {
        Value profiledPlanValue = metadata.get("profile");
        if (profiledPlanValue != null) {
            return InternalProfiledPlan.PROFILED_PLAN_FROM_VALUE.apply(profiledPlanValue);
        }
        return null;
    }

    private static List<Notification> extractNotifications(Map<String, Value> metadata) {
        Value notificationsValue = metadata.get("notifications");
        if (notificationsValue != null) {
            return notificationsValue.asList(InternalNotification.VALUE_TO_NOTIFICATION);
        }
        return Collections.emptyList();
    }

    private static long extractResultConsumedAfter(Map<String, Value> metadata) {
        Value resultConsumedAfterValue = metadata.get("result_consumed_after");
        if (resultConsumedAfterValue != null) {
            return resultConsumedAfterValue.asLong();
        }
        return -1L;
    }
}

