/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.async;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import java.util.function.Function;
import org.neo4j.driver.internal.handlers.PullAllResponseHandler;
import org.neo4j.driver.internal.handlers.RunResponseHandler;
import org.neo4j.driver.v1.Record;
import org.neo4j.driver.v1.StatementResultCursor;
import org.neo4j.driver.v1.exceptions.NoSuchRecordException;
import org.neo4j.driver.v1.summary.ResultSummary;

public class InternalStatementResultCursor
implements StatementResultCursor {
    private final RunResponseHandler runResponseHandler;
    private final PullAllResponseHandler pullAllHandler;
    private CompletionStage<Record> peekedRecordFuture;

    public InternalStatementResultCursor(RunResponseHandler runResponseHandler, PullAllResponseHandler pullAllHandler) {
        this.runResponseHandler = Objects.requireNonNull(runResponseHandler);
        this.pullAllHandler = Objects.requireNonNull(pullAllHandler);
    }

    @Override
    public List<String> keys() {
        List<String> keys = this.runResponseHandler.statementKeys();
        return keys == null ? Collections.emptyList() : Collections.unmodifiableList(keys);
    }

    @Override
    public CompletionStage<ResultSummary> summaryAsync() {
        return this.pullAllHandler.summaryAsync();
    }

    @Override
    public CompletionStage<Record> nextAsync() {
        if (this.peekedRecordFuture != null) {
            CompletionStage<Record> result = this.peekedRecordFuture;
            this.peekedRecordFuture = null;
            return result;
        }
        return this.pullAllHandler.nextAsync();
    }

    @Override
    public CompletionStage<Record> peekAsync() {
        if (this.peekedRecordFuture == null) {
            this.peekedRecordFuture = this.pullAllHandler.nextAsync();
        }
        return this.peekedRecordFuture;
    }

    @Override
    public CompletionStage<Record> singleAsync() {
        return this.nextAsync().thenCompose(firstRecord -> {
            if (firstRecord == null) {
                throw new NoSuchRecordException("Cannot retrieve a single record, because this cursor is empty.");
            }
            return this.nextAsync().thenApply(secondRecord -> {
                if (secondRecord != null) {
                    throw new NoSuchRecordException("Expected a cursor with a single record, but this cursor contains at least one more. Ensure your query returns only one record.");
                }
                return firstRecord;
            });
        });
    }

    @Override
    public CompletionStage<ResultSummary> consumeAsync() {
        return this.forEachAsync(record -> {});
    }

    @Override
    public CompletionStage<ResultSummary> forEachAsync(Consumer<Record> action) {
        CompletableFuture<Void> resultFuture = new CompletableFuture<Void>();
        this.internalForEachAsync(action, resultFuture);
        return resultFuture.thenCompose(ignore -> this.summaryAsync());
    }

    @Override
    public CompletionStage<List<Record>> listAsync() {
        return this.listAsync(Function.identity());
    }

    @Override
    public <T> CompletionStage<List<T>> listAsync(Function<Record, T> mapFunction) {
        CompletableFuture<List<T>> resultFuture = new CompletableFuture<List<T>>();
        this.internalListAsync(new ArrayList(), resultFuture, mapFunction);
        return resultFuture;
    }

    private void internalForEachAsync(Consumer<Record> action, CompletableFuture<Void> resultFuture) {
        CompletionStage<Record> recordFuture = this.nextAsync();
        recordFuture.whenCompleteAsync((record, error) -> {
            if (error != null) {
                resultFuture.completeExceptionally((Throwable)error);
            } else if (record != null) {
                try {
                    action.accept((Record)record);
                }
                catch (Throwable actionError) {
                    resultFuture.completeExceptionally(actionError);
                    return;
                }
                this.internalForEachAsync(action, resultFuture);
            } else {
                resultFuture.complete(null);
            }
        });
    }

    private <T> void internalListAsync(List<T> result, CompletableFuture<List<T>> resultFuture, Function<Record, T> mapFunction) {
        CompletionStage<Record> recordFuture = this.nextAsync();
        recordFuture.whenCompleteAsync((record, error) -> {
            if (error != null) {
                resultFuture.completeExceptionally((Throwable)error);
            } else if (record != null) {
                Object value;
                try {
                    value = mapFunction.apply((Record)record);
                }
                catch (Throwable mapError) {
                    resultFuture.completeExceptionally(mapError);
                    return;
                }
                result.add(value);
                this.internalListAsync(result, resultFuture, mapFunction);
            } else {
                resultFuture.complete(result);
            }
        });
    }
}

