/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.async;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.ReplayingDecoder;
import java.util.List;
import java.util.Objects;
import org.neo4j.driver.internal.async.inbound.ChunkDecoder;
import org.neo4j.driver.internal.async.inbound.InboundMessageHandler;
import org.neo4j.driver.internal.async.inbound.MessageDecoder;
import org.neo4j.driver.internal.async.outbound.OutboundMessageHandler;
import org.neo4j.driver.internal.logging.DevNullLogging;
import org.neo4j.driver.internal.messaging.PackStreamMessageFormatV1;
import org.neo4j.driver.v1.Logger;
import org.neo4j.driver.v1.Logging;
import org.neo4j.driver.v1.exceptions.ClientException;

public class HandshakeResponseHandler
extends ReplayingDecoder<Void> {
    private final ChannelPromise handshakeCompletedPromise;
    private final Logger log;

    public HandshakeResponseHandler(ChannelPromise handshakeCompletedPromise, Logging logging) {
        this.handshakeCompletedPromise = Objects.requireNonNull(handshakeCompletedPromise);
        this.log = logging.getLog(((Object)((Object)this)).getClass().getSimpleName());
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        this.fail(ctx, cause);
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) {
        int serverSuggestedVersion = in.readInt();
        this.log.debug("Server suggested protocol version: %s", serverSuggestedVersion);
        switch (serverSuggestedVersion) {
            case 1: {
                PackStreamMessageFormatV1 format = new PackStreamMessageFormatV1();
                ChannelPipeline pipeline = ctx.pipeline();
                pipeline.remove((ChannelHandler)this);
                pipeline.addLast(new ChannelHandler[]{new ChunkDecoder()});
                pipeline.addLast(new ChannelHandler[]{new MessageDecoder()});
                pipeline.addLast(new ChannelHandler[]{new InboundMessageHandler(format, DevNullLogging.DEV_NULL_LOGGING)});
                pipeline.addLast(OutboundMessageHandler.NAME, (ChannelHandler)new OutboundMessageHandler(format, DevNullLogging.DEV_NULL_LOGGING));
                this.handshakeCompletedPromise.setSuccess();
                break;
            }
            case 0: {
                this.fail(ctx, HandshakeResponseHandler.protocolNoSupportedByServerError());
                break;
            }
            case 1213486160: {
                this.fail(ctx, HandshakeResponseHandler.httpEndpointError());
                break;
            }
            default: {
                this.fail(ctx, HandshakeResponseHandler.protocolNoSupportedByDriverError(serverSuggestedVersion));
            }
        }
    }

    private void fail(ChannelHandlerContext ctx, Throwable error) {
        ctx.close().addListener(future -> this.handshakeCompletedPromise.setFailure(error));
    }

    private static Throwable protocolNoSupportedByServerError() {
        return new ClientException("The server does not support any of the protocol versions supported by this driver. Ensure that you are using driver and server versions that are compatible with one another.");
    }

    private static Throwable httpEndpointError() {
        return new ClientException("Server responded HTTP. Make sure you are not trying to connect to the http endpoint (HTTP defaults to port 7474 whereas BOLT defaults to port 7687)");
    }

    private static Throwable protocolNoSupportedByDriverError(int suggestedProtocolVersion) {
        return new ClientException("Protocol error, server suggested unexpected protocol version: " + suggestedProtocolVersion);
    }
}

