/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicBoolean;
import org.neo4j.driver.ResultResourcesHandler;
import org.neo4j.driver.internal.Bookmark;
import org.neo4j.driver.internal.ExplicitTransaction;
import org.neo4j.driver.internal.InternalStatementResult;
import org.neo4j.driver.internal.SessionResourcesHandler;
import org.neo4j.driver.internal.async.AsyncConnection;
import org.neo4j.driver.internal.async.Futures;
import org.neo4j.driver.internal.async.QueryRunner;
import org.neo4j.driver.internal.logging.DelegatingLogger;
import org.neo4j.driver.internal.retry.RetryLogic;
import org.neo4j.driver.internal.spi.Connection;
import org.neo4j.driver.internal.spi.ConnectionProvider;
import org.neo4j.driver.internal.spi.PooledConnection;
import org.neo4j.driver.internal.types.InternalTypeSystem;
import org.neo4j.driver.internal.util.Supplier;
import org.neo4j.driver.v1.AccessMode;
import org.neo4j.driver.v1.Logger;
import org.neo4j.driver.v1.Logging;
import org.neo4j.driver.v1.Record;
import org.neo4j.driver.v1.Session;
import org.neo4j.driver.v1.Statement;
import org.neo4j.driver.v1.StatementResult;
import org.neo4j.driver.v1.StatementResultCursor;
import org.neo4j.driver.v1.Transaction;
import org.neo4j.driver.v1.TransactionWork;
import org.neo4j.driver.v1.Value;
import org.neo4j.driver.v1.Values;
import org.neo4j.driver.v1.exceptions.ClientException;
import org.neo4j.driver.v1.types.TypeSystem;

public class NetworkSession
implements Session,
SessionResourcesHandler,
ResultResourcesHandler {
    private static final String LOG_NAME = "Session";
    private final ConnectionProvider connectionProvider;
    private final AccessMode mode;
    private final RetryLogic retryLogic;
    protected final Logger logger;
    private volatile Bookmark bookmark = Bookmark.empty();
    private PooledConnection currentConnection;
    private ExplicitTransaction currentTransaction;
    private volatile CompletionStage<ExplicitTransaction> asyncTransactionStage;
    private CompletionStage<AsyncConnection> asyncConnectionStage;
    private final AtomicBoolean isOpen = new AtomicBoolean(true);

    public NetworkSession(ConnectionProvider connectionProvider, AccessMode mode, RetryLogic retryLogic, Logging logging) {
        this.connectionProvider = connectionProvider;
        this.mode = mode;
        this.retryLogic = retryLogic;
        this.logger = new DelegatingLogger(logging.getLog(LOG_NAME), String.valueOf(this.hashCode()));
    }

    @Override
    public StatementResult run(String statementText) {
        return this.run(statementText, Values.EmptyMap);
    }

    @Override
    public CompletionStage<StatementResultCursor> runAsync(String statementText) {
        return this.runAsync(statementText, Values.EmptyMap);
    }

    @Override
    public StatementResult run(String statementText, Map<String, Object> statementParameters) {
        Value params = statementParameters == null ? Values.EmptyMap : Values.value(statementParameters);
        return this.run(statementText, params);
    }

    @Override
    public CompletionStage<StatementResultCursor> runAsync(String statementText, Map<String, Object> statementParameters) {
        Value params = statementParameters == null ? Values.EmptyMap : Values.value(statementParameters);
        return this.runAsync(statementText, params);
    }

    @Override
    public StatementResult run(String statementTemplate, Record statementParameters) {
        Value params = statementParameters == null ? Values.EmptyMap : Values.value(statementParameters.asMap());
        return this.run(statementTemplate, params);
    }

    @Override
    public CompletionStage<StatementResultCursor> runAsync(String statementTemplate, Record statementParameters) {
        Value params = statementParameters == null ? Values.EmptyMap : Values.value(statementParameters.asMap());
        return this.runAsync(statementTemplate, params);
    }

    @Override
    public StatementResult run(String statementText, Value statementParameters) {
        return this.run(new Statement(statementText, statementParameters));
    }

    @Override
    public CompletionStage<StatementResultCursor> runAsync(String statementText, Value parameters) {
        return this.runAsync(new Statement(statementText, parameters));
    }

    @Override
    public StatementResult run(Statement statement) {
        this.ensureSessionIsOpen();
        this.ensureNoOpenTransactionBeforeRunningSession();
        this.syncAndCloseCurrentConnection();
        this.currentConnection = this.acquireConnection(this.mode);
        return NetworkSession.run(this.currentConnection, statement, this);
    }

    @Override
    public CompletionStage<StatementResultCursor> runAsync(Statement statement) {
        this.ensureSessionIsOpen();
        this.ensureNoOpenTransactionBeforeRunningSession();
        return this.acquireAsyncConnection(this.mode).thenCompose(connection -> QueryRunner.runAsync(connection, statement));
    }

    public static StatementResult run(Connection connection, Statement statement, ResultResourcesHandler resourcesHandler) {
        InternalStatementResult result = new InternalStatementResult(statement, connection, resourcesHandler);
        connection.run(statement.text(), statement.parameters().asMap(Values.ofValue()), result.runResponseHandler());
        connection.pullAll(result.pullAllResponseHandler());
        connection.flush();
        return result;
    }

    @Override
    @Deprecated
    public synchronized void reset() {
        this.ensureSessionIsOpen();
        this.ensureNoUnrecoverableError();
        if (this.currentTransaction != null) {
            this.currentTransaction.markToClose();
            this.setBookmark(this.currentTransaction.bookmark());
            this.currentTransaction = null;
        }
        if (this.currentConnection != null) {
            this.currentConnection.resetAsync();
        }
    }

    @Override
    public boolean isOpen() {
        return this.isOpen.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (!this.isOpen.compareAndSet(true, false)) {
            throw new ClientException("This session has already been closed.");
        }
        NetworkSession networkSession = this;
        synchronized (networkSession) {
            if (this.currentTransaction != null) {
                try {
                    this.currentTransaction.close();
                }
                catch (Throwable e) {
                    this.logger.error("Failed to close transaction", e);
                }
            }
        }
        this.syncAndCloseCurrentConnection();
        try {
            this.closeAsync().toCompletableFuture().get();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CompletionStage<Void> closeAsync() {
        if (this.asyncConnectionStage != null) {
            return this.asyncConnectionStage.thenCompose(AsyncConnection::forceRelease);
        }
        if (this.asyncTransactionStage != null) {
            return this.asyncTransactionStage.thenCompose(ExplicitTransaction::rollbackAsync);
        }
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public synchronized Transaction beginTransaction() {
        return this.beginTransaction(this.mode);
    }

    @Override
    @Deprecated
    public synchronized Transaction beginTransaction(String bookmark) {
        this.setBookmark(Bookmark.from(bookmark));
        return this.beginTransaction();
    }

    @Override
    public CompletionStage<Transaction> beginTransactionAsync() {
        return this.beginTransactionAsync(this.mode);
    }

    @Override
    public <T> T readTransaction(TransactionWork<T> work) {
        return this.transaction(AccessMode.READ, work);
    }

    @Override
    public <T> CompletionStage<T> readTransactionAsync(TransactionWork<CompletionStage<T>> work) {
        return this.transactionAsync(AccessMode.READ, work);
    }

    @Override
    public <T> T writeTransaction(TransactionWork<T> work) {
        return this.transaction(AccessMode.WRITE, work);
    }

    @Override
    public <T> CompletionStage<T> writeTransactionAsync(TransactionWork<CompletionStage<T>> work) {
        return this.transactionAsync(AccessMode.WRITE, work);
    }

    void setBookmark(Bookmark bookmark) {
        if (bookmark != null && !bookmark.isEmpty()) {
            this.bookmark = bookmark;
        }
    }

    @Override
    public String lastBookmark() {
        return this.bookmark == null ? null : this.bookmark.maxBookmarkAsString();
    }

    @Override
    public TypeSystem typeSystem() {
        return InternalTypeSystem.TYPE_SYSTEM;
    }

    @Override
    public synchronized void onResultConsumed() {
        this.closeCurrentConnection();
    }

    @Override
    public void resultFetched() {
        this.closeCurrentConnection();
    }

    @Override
    public void resultFailed(Throwable error) {
        this.resultFetched();
    }

    @Override
    public synchronized void onTransactionClosed(ExplicitTransaction tx) {
        if (this.currentTransaction != null && this.currentTransaction == tx) {
            this.closeCurrentConnection();
            this.setBookmark(this.currentTransaction.bookmark());
            this.currentTransaction = null;
        }
    }

    public void asyncTransactionClosed(ExplicitTransaction tx) {
        this.setBookmark(tx.bookmark());
        this.asyncTransactionStage = null;
    }

    @Override
    public synchronized void onConnectionError(boolean recoverable) {
        if (this.currentTransaction != null) {
            if (recoverable) {
                this.currentTransaction.failure();
            } else {
                this.currentTransaction.markToClose();
            }
        }
    }

    private <T> T transaction(final AccessMode mode, final TransactionWork<T> work) {
        return this.retryLogic.retry(new Supplier<T>(){

            @Override
            public T get() {
                Throwable throwable = null;
                try (Transaction tx = NetworkSession.this.beginTransaction(mode);){
                    Object result = work.execute(tx);
                    tx.success();
                    Object t = result;
                    return t;
                }
                catch (Throwable t) {
                    try {
                        tx.failure();
                        throw t;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                }
            }
        });
    }

    private <T> CompletionStage<T> transactionAsync(AccessMode mode, TransactionWork<CompletionStage<T>> work) {
        return this.retryLogic.retryAsync(() -> {
            CompletableFuture resultFuture = new CompletableFuture();
            CompletionStage<ExplicitTransaction> txFuture = this.beginTransactionAsync(mode);
            txFuture.whenComplete((tx, error) -> {
                if (error != null) {
                    resultFuture.completeExceptionally((Throwable)error);
                } else {
                    this.executeWork(resultFuture, (ExplicitTransaction)tx, work);
                }
            });
            return resultFuture;
        });
    }

    private <T> void executeWork(CompletableFuture<T> resultFuture, ExplicitTransaction tx, TransactionWork<CompletionStage<T>> work) {
        CompletionStage<Object> workFuture = this.safeExecuteWork(tx, work);
        workFuture.whenComplete((result, error) -> {
            if (error != null) {
                this.rollbackTxAfterFailedTransactionWork(tx, resultFuture, (Throwable)error);
            } else {
                this.commitTxAfterSucceededTransactionWork(tx, resultFuture, result);
            }
        });
    }

    private <T> CompletionStage<T> safeExecuteWork(ExplicitTransaction tx, TransactionWork<CompletionStage<T>> work) {
        try {
            return work.execute(tx);
        }
        catch (Throwable workError) {
            return Futures.failedFuture(workError);
        }
    }

    private <T> void rollbackTxAfterFailedTransactionWork(ExplicitTransaction tx, CompletableFuture<T> resultFuture, Throwable error) {
        if (tx.isOpen()) {
            tx.rollbackAsync().whenComplete((ignore, rollbackError) -> {
                if (rollbackError != null) {
                    error.addSuppressed((Throwable)rollbackError);
                }
                resultFuture.completeExceptionally(error);
            });
        } else {
            resultFuture.completeExceptionally(error);
        }
    }

    private <T> void commitTxAfterSucceededTransactionWork(ExplicitTransaction tx, CompletableFuture<T> resultFuture, T result) {
        if (tx.isOpen()) {
            tx.commitAsync().whenComplete((ignore, commitError) -> {
                if (commitError != null) {
                    resultFuture.completeExceptionally((Throwable)commitError);
                } else {
                    resultFuture.complete(result);
                }
            });
        } else {
            resultFuture.complete(result);
        }
    }

    private synchronized Transaction beginTransaction(AccessMode mode) {
        this.ensureSessionIsOpen();
        this.ensureNoOpenTransactionBeforeOpeningTransaction();
        this.syncAndCloseCurrentConnection();
        this.currentConnection = this.acquireConnection(mode);
        ExplicitTransaction tx = new ExplicitTransaction(this.currentConnection, (SessionResourcesHandler)this);
        tx.begin(this.bookmark);
        this.currentTransaction = tx;
        this.currentConnection.setResourcesHandler(this);
        return this.currentTransaction;
    }

    private synchronized CompletionStage<ExplicitTransaction> beginTransactionAsync(AccessMode mode) {
        this.ensureSessionIsOpen();
        this.ensureNoOpenTransactionBeforeOpeningTransaction();
        this.asyncTransactionStage = this.acquireAsyncConnection(mode).thenCompose(connection -> {
            ExplicitTransaction tx = new ExplicitTransaction((AsyncConnection)connection, this);
            return tx.beginAsync(this.bookmark);
        });
        return this.asyncTransactionStage;
    }

    private void ensureNoUnrecoverableError() {
        if (this.currentConnection != null && this.currentConnection.hasUnrecoverableErrors()) {
            throw new ClientException("Cannot run more statements in the current session as an unrecoverable error has happened. Please close the current session and re-run your statement in a new session.");
        }
    }

    private void ensureNoOpenTransactionBeforeRunningSession() {
        if (this.currentTransaction != null || this.asyncTransactionStage != null) {
            throw new ClientException("Statements cannot be run directly on a session with an open transaction; either run from within the transaction or use a different session.");
        }
    }

    private void ensureNoOpenTransactionBeforeOpeningTransaction() {
        if (this.currentTransaction != null || this.asyncTransactionStage != null) {
            throw new ClientException("You cannot begin a transaction on a session with an open transaction; either run from within the transaction or use a different session.");
        }
    }

    private void ensureSessionIsOpen() {
        if (!this.isOpen.get()) {
            throw new ClientException("No more interaction with this session is allowed as the current session is already closed or marked as closed. You get this error either because you have a bad reference to a session that has already be closed or you are trying to reuse a session that you have called `reset` on it.");
        }
    }

    private PooledConnection acquireConnection(AccessMode mode) {
        PooledConnection connection = this.connectionProvider.acquireConnection(mode);
        this.logger.debug("Acquired connection " + connection.hashCode(), new Object[0]);
        return connection;
    }

    private CompletionStage<AsyncConnection> acquireAsyncConnection(AccessMode mode) {
        if (this.asyncConnectionStage == null) {
            this.asyncConnectionStage = this.connectionProvider.acquireAsyncConnection(mode);
        } else {
            CompletionStage<AsyncConnection> currentAsyncConnectionStage = this.asyncConnectionStage;
            this.asyncConnectionStage = currentAsyncConnectionStage.thenCompose(connection -> {
                if (connection.tryMarkInUse()) {
                    return currentAsyncConnectionStage;
                }
                return this.connectionProvider.acquireAsyncConnection(mode);
            });
        }
        return this.asyncConnectionStage;
    }

    boolean currentConnectionIsOpen() {
        return this.currentConnection != null && this.currentConnection.isOpen();
    }

    private void syncAndCloseCurrentConnection() {
        this.closeCurrentConnection(true);
    }

    private void closeCurrentConnection() {
        this.closeCurrentConnection(false);
    }

    private void closeCurrentConnection(boolean sync) {
        if (this.currentConnection == null) {
            return;
        }
        PooledConnection connection = this.currentConnection;
        this.currentConnection = null;
        try {
            if (sync && connection.isOpen()) {
                connection.sync();
            }
        }
        finally {
            connection.close();
            this.logger.debug("Released connection " + connection.hashCode(), new Object[0]);
        }
    }
}

