/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.EventLoopGroup;
import io.netty.util.concurrent.EventExecutorGroup;
import java.io.IOException;
import java.net.URI;
import java.security.GeneralSecurityException;
import org.neo4j.driver.internal.ConnectionSettings;
import org.neo4j.driver.internal.DirectConnectionProvider;
import org.neo4j.driver.internal.InternalDriver;
import org.neo4j.driver.internal.SessionFactory;
import org.neo4j.driver.internal.SessionFactoryImpl;
import org.neo4j.driver.internal.async.AsyncConnectorImpl;
import org.neo4j.driver.internal.async.BootstrapFactory;
import org.neo4j.driver.internal.async.Futures;
import org.neo4j.driver.internal.async.pool.AsyncConnectionPool;
import org.neo4j.driver.internal.async.pool.AsyncConnectionPoolImpl;
import org.neo4j.driver.internal.cluster.RoutingContext;
import org.neo4j.driver.internal.cluster.RoutingSettings;
import org.neo4j.driver.internal.cluster.loadbalancing.LeastConnectedLoadBalancingStrategy;
import org.neo4j.driver.internal.cluster.loadbalancing.LoadBalancer;
import org.neo4j.driver.internal.cluster.loadbalancing.LoadBalancingStrategy;
import org.neo4j.driver.internal.cluster.loadbalancing.RoundRobinLoadBalancingStrategy;
import org.neo4j.driver.internal.net.BoltServerAddress;
import org.neo4j.driver.internal.net.SocketConnector;
import org.neo4j.driver.internal.net.pooling.PoolSettings;
import org.neo4j.driver.internal.net.pooling.SocketConnectionPool;
import org.neo4j.driver.internal.retry.ExponentialBackoffRetryLogic;
import org.neo4j.driver.internal.retry.RetryLogic;
import org.neo4j.driver.internal.retry.RetrySettings;
import org.neo4j.driver.internal.security.SecurityPlan;
import org.neo4j.driver.internal.spi.ConnectionPool;
import org.neo4j.driver.internal.spi.ConnectionProvider;
import org.neo4j.driver.internal.spi.Connector;
import org.neo4j.driver.internal.util.Clock;
import org.neo4j.driver.v1.AuthToken;
import org.neo4j.driver.v1.AuthTokens;
import org.neo4j.driver.v1.Config;
import org.neo4j.driver.v1.Driver;
import org.neo4j.driver.v1.Logger;
import org.neo4j.driver.v1.Logging;
import org.neo4j.driver.v1.exceptions.ClientException;

public class DriverFactory {
    public static final String BOLT_URI_SCHEME = "bolt";
    public static final String BOLT_ROUTING_URI_SCHEME = "bolt+routing";

    public final Driver newInstance(URI uri, AuthToken authToken, RoutingSettings routingSettings, RetrySettings retrySettings, Config config) {
        authToken = authToken == null ? AuthTokens.none() : authToken;
        BoltServerAddress address = new BoltServerAddress(uri);
        RoutingSettings newRoutingSettings = routingSettings.withRoutingContext(new RoutingContext(uri));
        SecurityPlan securityPlan = DriverFactory.createSecurityPlan(address, config);
        ConnectionPool connectionPool = this.createConnectionPool(authToken, securityPlan, config);
        Bootstrap bootstrap = this.createBootstrap();
        EventLoopGroup eventExecutorGroup = bootstrap.config().group();
        RetryLogic retryLogic = this.createRetryLogic(retrySettings, (EventExecutorGroup)eventExecutorGroup, config.logging());
        AsyncConnectionPool asyncConnectionPool = this.createAsyncConnectionPool(authToken, securityPlan, bootstrap, config);
        try {
            return this.createDriver(uri, address, connectionPool, asyncConnectionPool, config, newRoutingSettings, (EventExecutorGroup)eventExecutorGroup, securityPlan, retryLogic);
        }
        catch (Throwable driverError) {
            try {
                connectionPool.close();
                Futures.getBlocking(asyncConnectionPool.close());
            }
            catch (Throwable closeError) {
                driverError.addSuppressed(closeError);
            }
            throw driverError;
        }
    }

    private AsyncConnectionPool createAsyncConnectionPool(AuthToken authToken, SecurityPlan securityPlan, Bootstrap bootstrap, Config config) {
        Clock clock = this.createClock();
        ConnectionSettings settings = new ConnectionSettings(authToken, config.connectionTimeoutMillis());
        AsyncConnectorImpl connector = new AsyncConnectorImpl(settings, securityPlan, config.logging(), clock);
        PoolSettings poolSettings = new PoolSettings(config.maxIdleConnectionPoolSize(), config.idleTimeBeforeConnectionTest(), config.maxConnectionLifetimeMillis(), config.maxConnectionPoolSize(), config.connectionAcquisitionTimeoutMillis());
        return new AsyncConnectionPoolImpl(connector, bootstrap, poolSettings, config.logging(), clock);
    }

    private Driver createDriver(URI uri, BoltServerAddress address, ConnectionPool connectionPool, AsyncConnectionPool asyncConnectionPool, Config config, RoutingSettings routingSettings, EventExecutorGroup eventExecutorGroup, SecurityPlan securityPlan, RetryLogic retryLogic) {
        String scheme;
        switch (scheme = uri.getScheme().toLowerCase()) {
            case "bolt": {
                DriverFactory.assertNoRoutingContext(uri, routingSettings);
                return this.createDirectDriver(address, connectionPool, config, securityPlan, retryLogic, asyncConnectionPool);
            }
            case "bolt+routing": {
                return this.createRoutingDriver(address, connectionPool, asyncConnectionPool, config, routingSettings, securityPlan, retryLogic, eventExecutorGroup);
            }
        }
        throw new ClientException(String.format("Unsupported URI scheme: %s", scheme));
    }

    protected Driver createDirectDriver(BoltServerAddress address, ConnectionPool connectionPool, Config config, SecurityPlan securityPlan, RetryLogic retryLogic, AsyncConnectionPool asyncConnectionPool) {
        DirectConnectionProvider connectionProvider = new DirectConnectionProvider(address, connectionPool, asyncConnectionPool);
        SessionFactory sessionFactory = this.createSessionFactory(connectionProvider, retryLogic, config);
        return this.createDriver(config, securityPlan, sessionFactory);
    }

    protected Driver createRoutingDriver(BoltServerAddress address, ConnectionPool connectionPool, AsyncConnectionPool asyncConnectionPool, Config config, RoutingSettings routingSettings, SecurityPlan securityPlan, RetryLogic retryLogic, EventExecutorGroup eventExecutorGroup) {
        if (!securityPlan.isRoutingCompatible()) {
            throw new IllegalArgumentException("The chosen security plan is not compatible with a routing driver");
        }
        LoadBalancer connectionProvider = this.createLoadBalancer(address, connectionPool, asyncConnectionPool, eventExecutorGroup, config, routingSettings);
        SessionFactory sessionFactory = this.createSessionFactory(connectionProvider, retryLogic, config);
        return this.createDriver(config, securityPlan, sessionFactory);
    }

    protected InternalDriver createDriver(Config config, SecurityPlan securityPlan, SessionFactory sessionFactory) {
        return new InternalDriver(securityPlan, sessionFactory, config.logging());
    }

    protected LoadBalancer createLoadBalancer(BoltServerAddress address, ConnectionPool connectionPool, AsyncConnectionPool asyncConnectionPool, EventExecutorGroup eventExecutorGroup, Config config, RoutingSettings routingSettings) {
        LoadBalancingStrategy loadBalancingStrategy = DriverFactory.createLoadBalancingStrategy(config, connectionPool, asyncConnectionPool);
        return new LoadBalancer(address, routingSettings, connectionPool, asyncConnectionPool, eventExecutorGroup, this.createClock(), config.logging(), loadBalancingStrategy);
    }

    private static LoadBalancingStrategy createLoadBalancingStrategy(Config config, ConnectionPool connectionPool, AsyncConnectionPool asyncConnectionPool) {
        switch (config.loadBalancingStrategy()) {
            case ROUND_ROBIN: {
                return new RoundRobinLoadBalancingStrategy(config.logging());
            }
            case LEAST_CONNECTED: {
                return new LeastConnectedLoadBalancingStrategy(connectionPool, asyncConnectionPool, config.logging());
            }
        }
        throw new IllegalArgumentException("Unknown load balancing strategy: " + (Object)((Object)config.loadBalancingStrategy()));
    }

    protected ConnectionPool createConnectionPool(AuthToken authToken, SecurityPlan securityPlan, Config config) {
        ConnectionSettings connectionSettings = new ConnectionSettings(authToken, config.connectionTimeoutMillis());
        PoolSettings poolSettings = new PoolSettings(config.maxIdleConnectionPoolSize(), config.idleTimeBeforeConnectionTest(), config.maxConnectionLifetimeMillis(), config.maxConnectionPoolSize(), config.connectionAcquisitionTimeoutMillis());
        Connector connector = this.createConnector(connectionSettings, securityPlan, config.logging());
        return new SocketConnectionPool(poolSettings, connector, this.createClock(), config.logging());
    }

    protected Clock createClock() {
        return Clock.SYSTEM;
    }

    protected Connector createConnector(ConnectionSettings connectionSettings, SecurityPlan securityPlan, Logging logging) {
        return new SocketConnector(connectionSettings, securityPlan, logging);
    }

    protected SessionFactory createSessionFactory(ConnectionProvider connectionProvider, RetryLogic retryLogic, Config config) {
        return new SessionFactoryImpl(connectionProvider, retryLogic, config);
    }

    protected RetryLogic createRetryLogic(RetrySettings settings, EventExecutorGroup eventExecutorGroup, Logging logging) {
        return new ExponentialBackoffRetryLogic(settings, eventExecutorGroup, this.createClock(), logging);
    }

    protected Bootstrap createBootstrap() {
        return BootstrapFactory.newBootstrap();
    }

    private static SecurityPlan createSecurityPlan(BoltServerAddress address, Config config) {
        try {
            return DriverFactory.createSecurityPlanImpl(address, config);
        }
        catch (IOException | GeneralSecurityException ex) {
            throw new ClientException("Unable to establish SSL parameters", ex);
        }
    }

    private static SecurityPlan createSecurityPlanImpl(BoltServerAddress address, Config config) throws GeneralSecurityException, IOException {
        if (config.encrypted()) {
            Logger logger = config.logging().getLog("SecurityPlan");
            switch (config.trustStrategy().strategy()) {
                case TRUST_ON_FIRST_USE: {
                    logger.warn("Option `TRUST_ON_FIRST_USE` has been deprecated and will be removed in a future version of the driver. Please switch to use `TRUST_ALL_CERTIFICATES` instead.", new Object[0]);
                    return SecurityPlan.forTrustOnFirstUse(config.trustStrategy().certFile(), address, logger);
                }
                case TRUST_SIGNED_CERTIFICATES: {
                    logger.warn("Option `TRUST_SIGNED_CERTIFICATE` has been deprecated and will be removed in a future version of the driver. Please switch to use `TRUST_CUSTOM_CA_SIGNED_CERTIFICATES` instead.", new Object[0]);
                }
                case TRUST_CUSTOM_CA_SIGNED_CERTIFICATES: {
                    return SecurityPlan.forCustomCASignedCertificates(config.trustStrategy().certFile());
                }
                case TRUST_SYSTEM_CA_SIGNED_CERTIFICATES: {
                    return SecurityPlan.forSystemCASignedCertificates();
                }
                case TRUST_ALL_CERTIFICATES: {
                    return SecurityPlan.forAllCertificates();
                }
            }
            throw new ClientException("Unknown TLS authentication strategy: " + config.trustStrategy().strategy().name());
        }
        return SecurityPlan.insecure();
    }

    private static void assertNoRoutingContext(URI uri, RoutingSettings routingSettings) {
        RoutingContext routingContext = routingSettings.routingContext();
        if (routingContext.isDefined()) {
            throw new IllegalArgumentException("Routing parameters are not supported with scheme 'bolt'. Given URI: '" + uri + "'");
        }
    }
}

