/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.handlers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.neo4j.driver.internal.ExplicitTransaction;
import org.neo4j.driver.internal.spi.ResponseHandler;
import org.neo4j.driver.v1.Value;

public class RunResponseHandler
implements ResponseHandler {
    private final CompletableFuture<Void> runCompletedFuture;
    private final ExplicitTransaction tx;
    private List<String> statementKeys;
    private long resultAvailableAfter;

    public RunResponseHandler(CompletableFuture<Void> runCompletedFuture, ExplicitTransaction tx) {
        this.runCompletedFuture = runCompletedFuture;
        this.tx = tx;
    }

    @Override
    public void onSuccess(Map<String, Value> metadata) {
        this.statementKeys = RunResponseHandler.extractKeys(metadata);
        this.resultAvailableAfter = RunResponseHandler.extractResultAvailableAfter(metadata);
        if (this.runCompletedFuture != null) {
            this.runCompletedFuture.complete(null);
        }
    }

    @Override
    public void onFailure(Throwable error) {
        if (this.tx != null) {
            this.tx.resultFailed(error);
        }
        if (this.runCompletedFuture != null) {
            this.runCompletedFuture.completeExceptionally(error);
        }
    }

    @Override
    public void onRecord(Value[] fields) {
        throw new UnsupportedOperationException();
    }

    public List<String> statementKeys() {
        return this.statementKeys;
    }

    public long resultAvailableAfter() {
        return this.resultAvailableAfter;
    }

    private static List<String> extractKeys(Map<String, Value> metadata) {
        Value keysValue = metadata.get("fields");
        if (keysValue != null && !keysValue.isEmpty()) {
            ArrayList<String> keys = new ArrayList<String>(keysValue.size());
            for (Value value : keysValue.values()) {
                keys.add(value.asString());
            }
            return keys;
        }
        return Collections.emptyList();
    }

    private static long extractResultAvailableAfter(Map<String, Value> metadata) {
        Value resultAvailableAfterValue = metadata.get("result_available_after");
        if (resultAvailableAfterValue != null) {
            return resultAvailableAfterValue.asLong();
        }
        return -1L;
    }
}

