/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.async.pool;

import io.netty.channel.Channel;
import io.netty.channel.pool.ChannelPoolHandler;
import io.netty.util.internal.ConcurrentSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.neo4j.driver.internal.async.ChannelAttributes;
import org.neo4j.driver.internal.net.BoltServerAddress;
import org.neo4j.driver.v1.Logger;
import org.neo4j.driver.v1.Logging;

public class ActiveChannelTracker
implements ChannelPoolHandler {
    private final ConcurrentMap<BoltServerAddress, ConcurrentSet<Channel>> addressToActiveChannelCount = new ConcurrentHashMap<BoltServerAddress, ConcurrentSet<Channel>>();
    private final Logger log;

    public ActiveChannelTracker(Logging logging) {
        this.log = logging.getLog(this.getClass().getSimpleName());
    }

    public void channelReleased(Channel channel) {
        this.log.debug("Channel %s released back to the pool", channel);
        this.channelInactive(channel);
    }

    public void channelAcquired(Channel channel) {
        this.log.debug("Channel %s acquired from the pool", channel);
        this.channelActive(channel);
    }

    public void channelCreated(Channel channel) {
        this.log.debug("Channel %s created", channel);
        this.channelActive(channel);
    }

    public int activeChannelCount(BoltServerAddress address) {
        ConcurrentSet activeChannels = (ConcurrentSet)this.addressToActiveChannelCount.get(address);
        return activeChannels == null ? 0 : activeChannels.size();
    }

    public void purge(BoltServerAddress address) {
        ConcurrentSet activeChannels = (ConcurrentSet)this.addressToActiveChannelCount.remove(address);
        if (activeChannels != null) {
            for (Channel channel : activeChannels) {
                channel.close();
            }
        }
    }

    private void channelActive(Channel channel) {
        BoltServerAddress address = ChannelAttributes.address(channel);
        Object activeChannels = (ConcurrentSet<Channel>)this.addressToActiveChannelCount.get(address);
        if (activeChannels == null) {
            ConcurrentSet newActiveChannels = new ConcurrentSet();
            ConcurrentSet<Channel> existingActiveChannels = this.addressToActiveChannelCount.putIfAbsent(address, (ConcurrentSet<Channel>)newActiveChannels);
            activeChannels = existingActiveChannels == null ? newActiveChannels : existingActiveChannels;
        }
        activeChannels.add((Object)channel);
    }

    private void channelInactive(Channel channel) {
        BoltServerAddress address = ChannelAttributes.address(channel);
        ConcurrentSet activeChannels = (ConcurrentSet)this.addressToActiveChannelCount.get(address);
        if (activeChannels == null) {
            throw new IllegalStateException("No channels exist for address '" + address + "'");
        }
        activeChannels.remove((Object)channel);
    }
}

