/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.async.inbound;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import java.util.List;

public class MessageDecoder
extends ByteToMessageDecoder {
    private boolean readMessageBoundary;

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof ByteBuf) {
            this.readMessageBoundary = ((ByteBuf)msg).readableBytes() == 0;
        }
        super.channelRead(ctx, msg);
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        if (this.readMessageBoundary) {
            in.retain();
            ByteBuf res = in.duplicate();
            in.readerIndex(in.readableBytes());
            out.add(res);
            this.readMessageBoundary = false;
        }
    }
}

