/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.async.inbound;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import java.io.IOException;
import org.neo4j.driver.internal.async.ChannelAttributes;
import org.neo4j.driver.internal.async.inbound.ByteBufInput;
import org.neo4j.driver.internal.async.inbound.InboundMessageDispatcher;
import org.neo4j.driver.internal.messaging.MessageFormat;
import org.neo4j.driver.v1.Logger;
import org.neo4j.driver.v1.Logging;
import org.neo4j.driver.v1.exceptions.ServiceUnavailableException;

public class InboundMessageHandler
extends SimpleChannelInboundHandler<ByteBuf> {
    private final ByteBufInput input = new ByteBufInput();
    private final MessageFormat.Reader reader;
    private final Logger log;
    private InboundMessageDispatcher messageDispatcher;

    public InboundMessageHandler(MessageFormat messageFormat, Logging logging) {
        this.reader = messageFormat.newReader(this.input);
        this.log = logging.getLog(((Object)((Object)this)).getClass().getSimpleName());
    }

    public void handlerAdded(ChannelHandlerContext ctx) {
        this.messageDispatcher = ChannelAttributes.messageDispatcher(ctx.channel());
    }

    protected void channelRead0(ChannelHandlerContext ctx, ByteBuf msg) throws IOException {
        this.input.start(msg);
        try {
            this.reader.read(this.messageDispatcher);
        }
        finally {
            this.input.stop();
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        this.log.warn("Fatal error in pipeline for channel " + ctx.channel(), cause);
        this.messageDispatcher.handleFatalError(InboundMessageHandler.wrapFatalError(cause));
        ctx.close();
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        this.log.debug("Channel inactive: %s", ctx.channel());
        this.messageDispatcher.handleFatalError(new ServiceUnavailableException("Connection to the database terminated. This can happen due to network instabilities, or due to restarts of the database"));
        ctx.close();
    }

    private static Throwable wrapFatalError(Throwable error) {
        if (error instanceof IOException) {
            return new ServiceUnavailableException("Connection to the database failed", error);
        }
        return error;
    }
}

