/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.async;

import io.netty.util.internal.PlatformDependent;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public final class Futures {
    private Futures() {
    }

    public static <T> CompletionStage<T> asCompletionStage(io.netty.util.concurrent.Future<T> future) {
        CompletableFuture<Object> result = new CompletableFuture<Object>();
        if (future.isCancelled()) {
            result.cancel(true);
        } else if (future.isSuccess()) {
            result.complete(future.getNow());
        } else {
            future.addListener(ignore -> {
                if (future.isCancelled()) {
                    result.cancel(true);
                } else if (future.isSuccess()) {
                    result.complete(future.getNow());
                } else {
                    result.completeExceptionally(future.cause());
                }
            });
        }
        return result;
    }

    public static <T> CompletableFuture<T> failedFuture(Throwable error) {
        CompletableFuture result = new CompletableFuture();
        result.completeExceptionally(error);
        return result;
    }

    public static <V> V getBlocking(CompletionStage<V> stage) {
        CompletableFuture<V> future = stage.toCompletableFuture();
        return Futures.getBlocking(future);
    }

    public static <V> V getBlocking(Future<V> future) {
        boolean interrupted = false;
        while (true) {
            try {
                V v = future.get();
                return v;
            }
            catch (InterruptedException e) {
                interrupted = true;
                continue;
            }
            catch (ExecutionException e) {
                PlatformDependent.throwException((Throwable)e.getCause());
                continue;
            }
            break;
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

