/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.messaging;

import java.io.IOException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.neo4j.driver.internal.InternalNode;
import org.neo4j.driver.internal.InternalPath;
import org.neo4j.driver.internal.InternalRelationship;
import org.neo4j.driver.internal.messaging.Message;
import org.neo4j.driver.internal.messaging.MessageFormat;
import org.neo4j.driver.internal.messaging.MessageHandler;
import org.neo4j.driver.internal.net.BufferingChunkedInput;
import org.neo4j.driver.internal.net.ChunkedOutput;
import org.neo4j.driver.internal.packstream.ByteArrayIncompatiblePacker;
import org.neo4j.driver.internal.packstream.PackInput;
import org.neo4j.driver.internal.packstream.PackOutput;
import org.neo4j.driver.internal.packstream.PackStream;
import org.neo4j.driver.internal.packstream.PackType;
import org.neo4j.driver.internal.util.Iterables;
import org.neo4j.driver.internal.value.InternalValue;
import org.neo4j.driver.internal.value.ListValue;
import org.neo4j.driver.internal.value.MapValue;
import org.neo4j.driver.internal.value.NodeValue;
import org.neo4j.driver.internal.value.PathValue;
import org.neo4j.driver.internal.value.RelationshipValue;
import org.neo4j.driver.v1.Value;
import org.neo4j.driver.v1.Values;
import org.neo4j.driver.v1.exceptions.ClientException;
import org.neo4j.driver.v1.types.Entity;
import org.neo4j.driver.v1.types.Node;
import org.neo4j.driver.v1.types.Path;
import org.neo4j.driver.v1.types.Relationship;

public class PackStreamMessageFormatV1
implements MessageFormat {
    public static final byte MSG_INIT = 1;
    public static final byte MSG_ACK_FAILURE = 14;
    public static final byte MSG_RESET = 15;
    public static final byte MSG_RUN = 16;
    public static final byte MSG_DISCARD_ALL = 47;
    public static final byte MSG_PULL_ALL = 63;
    public static final byte MSG_RECORD = 113;
    public static final byte MSG_SUCCESS = 112;
    public static final byte MSG_IGNORED = 126;
    public static final byte MSG_FAILURE = 127;
    public static final byte NODE = 78;
    public static final byte RELATIONSHIP = 82;
    public static final byte UNBOUND_RELATIONSHIP = 114;
    public static final byte PATH = 80;
    public static final int VERSION = 1;
    public static final int NODE_FIELDS = 3;
    private static final Map<String, Value> EMPTY_STRING_VALUE_MAP = new HashMap<String, Value>(0);

    @Override
    public MessageFormat.Writer newWriter(WritableByteChannel ch, boolean byteArraySupportEnabled) {
        ChunkedOutput output = new ChunkedOutput(ch);
        return new Writer(output, output.messageBoundaryHook(), byteArraySupportEnabled);
    }

    @Override
    public MessageFormat.Reader newReader(ReadableByteChannel ch) {
        BufferingChunkedInput input = new BufferingChunkedInput(ch);
        return new Reader(input, input.messageBoundaryHook());
    }

    @Override
    public int version() {
        return 1;
    }

    public static class NoOpRunnable
    implements Runnable {
        @Override
        public void run() {
        }
    }

    public static class Reader
    implements MessageFormat.Reader {
        private final PackStream.Unpacker unpacker;
        private final Runnable onMessageComplete;

        public Reader(PackInput input, Runnable onMessageComplete) {
            this.unpacker = new PackStream.Unpacker(input);
            this.onMessageComplete = onMessageComplete;
        }

        @Override
        public boolean hasNext() throws IOException {
            return this.unpacker.hasNext();
        }

        @Override
        public void read(MessageHandler handler) throws IOException {
            this.unpacker.unpackStructHeader();
            byte type = this.unpacker.unpackStructSignature();
            switch (type) {
                case 16: {
                    this.unpackRunMessage(handler);
                    break;
                }
                case 47: {
                    this.unpackDiscardAllMessage(handler);
                    break;
                }
                case 63: {
                    this.unpackPullAllMessage(handler);
                    break;
                }
                case 113: {
                    this.unpackRecordMessage(handler);
                    break;
                }
                case 112: {
                    this.unpackSuccessMessage(handler);
                    break;
                }
                case 127: {
                    this.unpackFailureMessage(handler);
                    break;
                }
                case 126: {
                    this.unpackIgnoredMessage(handler);
                    break;
                }
                case 1: {
                    this.unpackInitMessage(handler);
                    break;
                }
                case 15: {
                    this.unpackResetMessage(handler);
                    break;
                }
                default: {
                    throw new IOException("Unknown message type: " + type);
                }
            }
        }

        private void unpackResetMessage(MessageHandler handler) throws IOException {
            handler.handleResetMessage();
            this.onMessageComplete.run();
        }

        private void unpackInitMessage(MessageHandler handler) throws IOException {
            handler.handleInitMessage(this.unpacker.unpackString(), this.unpackMap());
            this.onMessageComplete.run();
        }

        private void unpackIgnoredMessage(MessageHandler output) throws IOException {
            output.handleIgnoredMessage();
            this.onMessageComplete.run();
        }

        private void unpackFailureMessage(MessageHandler output) throws IOException {
            Map<String, Value> params = this.unpackMap();
            String code = params.get("code").asString();
            String message = params.get("message").asString();
            output.handleFailureMessage(code, message);
            this.onMessageComplete.run();
        }

        private void unpackRunMessage(MessageHandler output) throws IOException {
            String statement = this.unpacker.unpackString();
            Map<String, Value> params = this.unpackMap();
            output.handleRunMessage(statement, params);
            this.onMessageComplete.run();
        }

        private void unpackDiscardAllMessage(MessageHandler output) throws IOException {
            output.handleDiscardAllMessage();
            this.onMessageComplete.run();
        }

        private void unpackPullAllMessage(MessageHandler output) throws IOException {
            output.handlePullAllMessage();
            this.onMessageComplete.run();
        }

        private void unpackSuccessMessage(MessageHandler output) throws IOException {
            Map<String, Value> map = this.unpackMap();
            output.handleSuccessMessage(map);
            this.onMessageComplete.run();
        }

        private void unpackRecordMessage(MessageHandler output) throws IOException {
            int fieldCount = (int)this.unpacker.unpackListHeader();
            Value[] fields = new Value[fieldCount];
            for (int i = 0; i < fieldCount; ++i) {
                fields[i] = this.unpackValue();
            }
            output.handleRecordMessage(fields);
            this.onMessageComplete.run();
        }

        private Value unpackValue() throws IOException {
            PackType type = this.unpacker.peekNextType();
            switch (type) {
                case NULL: {
                    return Values.value(this.unpacker.unpackNull());
                }
                case BOOLEAN: {
                    return Values.value(this.unpacker.unpackBoolean());
                }
                case INTEGER: {
                    return Values.value(this.unpacker.unpackLong());
                }
                case FLOAT: {
                    return Values.value(this.unpacker.unpackDouble());
                }
                case BYTES: {
                    return Values.value(this.unpacker.unpackBytes());
                }
                case STRING: {
                    return Values.value(this.unpacker.unpackString());
                }
                case MAP: {
                    return new MapValue(this.unpackMap());
                }
                case LIST: {
                    int size = (int)this.unpacker.unpackListHeader();
                    Value[] vals = new Value[size];
                    for (int j = 0; j < size; ++j) {
                        vals[j] = this.unpackValue();
                    }
                    return new ListValue(vals);
                }
                case STRUCT: {
                    long size = this.unpacker.unpackStructHeader();
                    switch (this.unpacker.unpackStructSignature()) {
                        case 78: {
                            this.ensureCorrectStructSize("NODE", 3, size);
                            InternalNode adapted = this.unpackNode();
                            return new NodeValue(adapted);
                        }
                        case 82: {
                            this.ensureCorrectStructSize("RELATIONSHIP", 5, size);
                            return this.unpackRelationship();
                        }
                        case 80: {
                            this.ensureCorrectStructSize("PATH", 3, size);
                            return this.unpackPath();
                        }
                    }
                }
            }
            throw new IOException("Unknown value type: " + (Object)((Object)type));
        }

        private Value unpackRelationship() throws IOException {
            long urn = this.unpacker.unpackLong();
            long startUrn = this.unpacker.unpackLong();
            long endUrn = this.unpacker.unpackLong();
            String relType = this.unpacker.unpackString();
            Map<String, Value> props = this.unpackMap();
            InternalRelationship adapted = new InternalRelationship(urn, startUrn, endUrn, relType, props);
            return new RelationshipValue(adapted);
        }

        private InternalNode unpackNode() throws IOException {
            long urn = this.unpacker.unpackLong();
            int numLabels = (int)this.unpacker.unpackListHeader();
            ArrayList<String> labels = new ArrayList<String>(numLabels);
            for (int i = 0; i < numLabels; ++i) {
                labels.add(this.unpacker.unpackString());
            }
            int numProps = (int)this.unpacker.unpackMapHeader();
            HashMap<String, Value> props = new HashMap<String, Value>();
            for (int j = 0; j < numProps; ++j) {
                String key = this.unpacker.unpackString();
                props.put(key, this.unpackValue());
            }
            return new InternalNode(urn, labels, props);
        }

        private Value unpackPath() throws IOException {
            Node prevNode;
            Node[] uniqNodes = new Node[(int)this.unpacker.unpackListHeader()];
            for (int i = 0; i < uniqNodes.length; ++i) {
                this.ensureCorrectStructSize("NODE", 3, this.unpacker.unpackStructHeader());
                this.ensureCorrectStructSignature("NODE", (byte)78, this.unpacker.unpackStructSignature());
                uniqNodes[i] = this.unpackNode();
            }
            InternalRelationship[] uniqRels = new InternalRelationship[(int)this.unpacker.unpackListHeader()];
            for (int i = 0; i < uniqRels.length; ++i) {
                this.ensureCorrectStructSize("RELATIONSHIP", 3, this.unpacker.unpackStructHeader());
                this.ensureCorrectStructSignature("UNBOUND_RELATIONSHIP", (byte)114, this.unpacker.unpackStructSignature());
                long id = this.unpacker.unpackLong();
                String relType = this.unpacker.unpackString();
                Map<String, Value> props = this.unpackMap();
                uniqRels[i] = new InternalRelationship(id, -1L, -1L, relType, props);
            }
            int length = (int)this.unpacker.unpackListHeader();
            Path.Segment[] segments = new Path.Segment[length / 2];
            Node[] nodes = new Node[segments.length + 1];
            Relationship[] rels = new Relationship[segments.length];
            nodes[0] = prevNode = uniqNodes[0];
            for (int i = 0; i < segments.length; ++i) {
                InternalRelationship rel;
                int relIdx = (int)this.unpacker.unpackLong();
                Node nextNode = uniqNodes[(int)this.unpacker.unpackLong()];
                if (relIdx < 0) {
                    rel = uniqRels[-relIdx - 1];
                    rel.setStartAndEnd(nextNode.id(), prevNode.id());
                } else {
                    rel = uniqRels[relIdx - 1];
                    rel.setStartAndEnd(prevNode.id(), nextNode.id());
                }
                nodes[i + 1] = nextNode;
                rels[i] = rel;
                segments[i] = new InternalPath.SelfContainedSegment(prevNode, rel, nextNode);
                prevNode = nextNode;
            }
            return new PathValue(new InternalPath(Arrays.asList(segments), Arrays.asList(nodes), Arrays.asList(rels)));
        }

        private void ensureCorrectStructSize(String structName, int expected, long actual) {
            if ((long)expected != actual) {
                throw new ClientException(String.format("Invalid message received, serialized %s structures should have %d fields, received %s structure has %d fields.", structName, expected, structName, actual));
            }
        }

        private void ensureCorrectStructSignature(String structName, byte expected, byte actual) {
            if (expected != actual) {
                throw new ClientException(String.format("Invalid message received, expected a `%s`, signature 0x%s. Recieved signature was 0x%s.", structName, Integer.toHexString(expected), Integer.toHexString(actual)));
            }
        }

        private Map<String, Value> unpackMap() throws IOException {
            int size = (int)this.unpacker.unpackMapHeader();
            if (size == 0) {
                return EMPTY_STRING_VALUE_MAP;
            }
            HashMap<String, Value> map = new HashMap<String, Value>(size);
            for (int i = 0; i < size; ++i) {
                String key = this.unpacker.unpackString();
                map.put(key, this.unpackValue());
            }
            return map;
        }
    }

    public static class Writer
    implements MessageFormat.Writer,
    MessageHandler {
        private final PackStream.Packer packer;
        private final Runnable onMessageComplete;

        public Writer(PackOutput output, Runnable onMessageComplete, boolean byteArraySupportEnabled) {
            this.onMessageComplete = onMessageComplete;
            this.packer = byteArraySupportEnabled ? new PackStream.Packer(output) : new ByteArrayIncompatiblePacker(output);
        }

        @Override
        public void handleInitMessage(String clientNameAndVersion, Map<String, Value> authToken) throws IOException {
            this.packer.packStructHeader(1, (byte)1);
            this.packer.pack(clientNameAndVersion);
            this.packRawMap(authToken);
            this.onMessageComplete.run();
        }

        @Override
        public void handleRunMessage(String statement, Map<String, Value> parameters) throws IOException {
            this.packer.packStructHeader(2, (byte)16);
            this.packer.pack(statement);
            this.packRawMap(parameters);
            this.onMessageComplete.run();
        }

        @Override
        public void handlePullAllMessage() throws IOException {
            this.packer.packStructHeader(0, (byte)63);
            this.onMessageComplete.run();
        }

        @Override
        public void handleDiscardAllMessage() throws IOException {
            this.packer.packStructHeader(0, (byte)47);
            this.onMessageComplete.run();
        }

        @Override
        public void handleResetMessage() throws IOException {
            this.packer.packStructHeader(0, (byte)15);
            this.onMessageComplete.run();
        }

        @Override
        public void handleAckFailureMessage() throws IOException {
            this.packer.packStructHeader(0, (byte)14);
            this.onMessageComplete.run();
        }

        @Override
        public void handleSuccessMessage(Map<String, Value> meta) throws IOException {
            this.packer.packStructHeader(1, (byte)112);
            this.packRawMap(meta);
            this.onMessageComplete.run();
        }

        @Override
        public void handleRecordMessage(Value[] fields) throws IOException {
            this.packer.packStructHeader(1, (byte)113);
            this.packer.packListHeader(fields.length);
            for (Value field : fields) {
                this.packValue(field);
            }
            this.onMessageComplete.run();
        }

        @Override
        public void handleFailureMessage(String code, String message) throws IOException {
            this.packer.packStructHeader(1, (byte)127);
            this.packer.packMapHeader(2);
            this.packer.pack("code");
            this.packValue(Values.value(code));
            this.packer.pack("message");
            this.packValue(Values.value(message));
            this.onMessageComplete.run();
        }

        @Override
        public void handleIgnoredMessage() throws IOException {
            this.packer.packStructHeader(0, (byte)126);
            this.onMessageComplete.run();
        }

        private void packRawMap(Map<String, Value> map) throws IOException {
            if (map == null || map.size() == 0) {
                this.packer.packMapHeader(0);
                return;
            }
            this.packer.packMapHeader(map.size());
            for (Map.Entry<String, Value> entry : map.entrySet()) {
                this.packer.pack(entry.getKey());
                this.packValue(entry.getValue());
            }
        }

        private void packValue(Value value) throws IOException {
            switch (((InternalValue)value).typeConstructor()) {
                case NULL_TyCon: {
                    this.packer.packNull();
                    break;
                }
                case BYTES_TyCon: {
                    this.packer.pack(value.asByteArray());
                    break;
                }
                case STRING_TyCon: {
                    this.packer.pack(value.asString());
                    break;
                }
                case BOOLEAN_TyCon: {
                    this.packer.pack(value.asBoolean());
                    break;
                }
                case INTEGER_TyCon: {
                    this.packer.pack(value.asLong());
                    break;
                }
                case FLOAT_TyCon: {
                    this.packer.pack(value.asDouble());
                    break;
                }
                case MAP_TyCon: {
                    this.packer.packMapHeader(value.size());
                    for (String s : value.keys()) {
                        this.packer.pack(s);
                        this.packValue(value.get(s));
                    }
                    break;
                }
                case LIST_TyCon: {
                    this.packer.packListHeader(value.size());
                    for (Value item : value.values()) {
                        this.packValue(item);
                    }
                    break;
                }
                case NODE_TyCon: {
                    Node node = value.asNode();
                    this.packNode(node);
                    break;
                }
                case RELATIONSHIP_TyCon: {
                    Relationship rel = value.asRelationship();
                    this.packer.packStructHeader(5, (byte)82);
                    this.packer.pack(rel.id());
                    this.packer.pack(rel.startNodeId());
                    this.packer.pack(rel.endNodeId());
                    this.packer.pack(rel.type());
                    this.packProperties(rel);
                    break;
                }
                case PATH_TyCon: {
                    Path path = value.asPath();
                    this.packer.packStructHeader(3, (byte)80);
                    LinkedHashMap<Node, Integer> nodeIdx = new LinkedHashMap<Node, Integer>();
                    for (Node node : path.nodes()) {
                        if (nodeIdx.containsKey(node)) continue;
                        nodeIdx.put(node, nodeIdx.size());
                    }
                    this.packer.packListHeader(nodeIdx.size());
                    for (Node node : nodeIdx.keySet()) {
                        this.packNode(node);
                    }
                    LinkedHashMap<Relationship, Integer> relIdx = new LinkedHashMap<Relationship, Integer>();
                    for (Relationship rel : path.relationships()) {
                        if (relIdx.containsKey(rel)) continue;
                        relIdx.put(rel, relIdx.size() + 1);
                    }
                    this.packer.packListHeader(relIdx.size());
                    for (Relationship rel : relIdx.keySet()) {
                        this.packer.packStructHeader(3, (byte)114);
                        this.packer.pack(rel.id());
                        this.packer.pack(rel.type());
                        this.packProperties(rel);
                    }
                    this.packer.packListHeader(path.length() * 2);
                    for (Path.Segment seg : path) {
                        long segEndId;
                        Relationship rel = seg.relationship();
                        long relEndId = rel.endNodeId();
                        this.packer.pack(relEndId == (segEndId = seg.end().id()) ? (long)((Integer)relIdx.get(rel)).intValue() : (long)(-((Integer)relIdx.get(rel)).intValue()));
                        this.packer.pack(nodeIdx.get(seg.end()));
                    }
                    break;
                }
                default: {
                    throw new IOException("Unknown type: " + value);
                }
            }
        }

        @Override
        public Writer flush() throws IOException {
            this.packer.flush();
            return this;
        }

        @Override
        public Writer write(Message msg) throws IOException {
            msg.dispatch(this);
            return this;
        }

        private void packNode(Node node) throws IOException {
            this.packer.packStructHeader(3, (byte)78);
            this.packer.pack(node.id());
            Iterable<String> labels = node.labels();
            this.packer.packListHeader(Iterables.count(labels));
            for (String label : labels) {
                this.packer.pack(label);
            }
            this.packProperties(node);
        }

        private void packProperties(Entity entity) throws IOException {
            Iterable<String> keys = entity.keys();
            this.packer.packMapHeader(entity.size());
            for (String propKey : keys) {
                this.packer.pack(propKey);
                this.packValue(entity.get(propKey));
            }
        }
    }
}

