/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.cluster;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.neo4j.driver.internal.net.BoltServerAddress;

public class RoundRobinAddressSet {
    private static final BoltServerAddress[] NONE = new BoltServerAddress[0];
    private final AtomicInteger offset = new AtomicInteger();
    private volatile BoltServerAddress[] addresses = NONE;

    public int size() {
        return this.addresses.length;
    }

    public BoltServerAddress next() {
        BoltServerAddress[] addresses = this.addresses;
        if (addresses.length == 0) {
            return null;
        }
        return addresses[this.next(addresses.length)];
    }

    public Set<BoltServerAddress> servers() {
        return new HashSet<BoltServerAddress>(Arrays.asList(this.addresses));
    }

    int next(int divisor) {
        int index = this.offset.getAndIncrement();
        while (index == Integer.MAX_VALUE) {
            this.offset.compareAndSet(Integer.MIN_VALUE, index % divisor);
            index = this.offset.getAndIncrement();
        }
        return index % divisor;
    }

    public synchronized void update(Set<BoltServerAddress> addresses) {
        this.addresses = addresses.toArray(NONE);
    }

    public synchronized void remove(BoltServerAddress address) {
        BoltServerAddress[] addresses = this.addresses;
        if (addresses != null) {
            for (int i = 0; i < addresses.length; ++i) {
                if (!addresses[i].equals(address)) continue;
                if (addresses.length == 1) {
                    this.addresses = NONE;
                    return;
                }
                BoltServerAddress[] copy = new BoltServerAddress[addresses.length - 1];
                System.arraycopy(addresses, 0, copy, 0, i);
                System.arraycopy(addresses, i + 1, copy, i, addresses.length - i - 1);
                this.addresses = copy;
                return;
            }
        }
    }

    public String toString() {
        return "RoundRobinAddressSet=" + Arrays.toString(this.addresses);
    }

    void setOffset(int target) {
        this.offset.set(target);
    }
}

