/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal;

import java.util.Collections;
import java.util.Map;
import org.neo4j.driver.internal.Bookmark;
import org.neo4j.driver.internal.BookmarkCollector;
import org.neo4j.driver.internal.InternalStatementResult;
import org.neo4j.driver.internal.SessionResourcesHandler;
import org.neo4j.driver.internal.spi.Collector;
import org.neo4j.driver.internal.spi.Connection;
import org.neo4j.driver.internal.types.InternalTypeSystem;
import org.neo4j.driver.v1.Record;
import org.neo4j.driver.v1.Statement;
import org.neo4j.driver.v1.StatementResult;
import org.neo4j.driver.v1.Transaction;
import org.neo4j.driver.v1.Value;
import org.neo4j.driver.v1.Values;
import org.neo4j.driver.v1.exceptions.ClientException;
import org.neo4j.driver.v1.exceptions.Neo4jException;
import org.neo4j.driver.v1.types.TypeSystem;

public class ExplicitTransaction
implements Transaction {
    private final SessionResourcesHandler resourcesHandler;
    private final Connection conn;
    private Bookmark bookmark = Bookmark.empty();
    private State state = State.ACTIVE;

    public ExplicitTransaction(Connection conn, SessionResourcesHandler resourcesHandler) {
        this(conn, resourcesHandler, Bookmark.empty());
    }

    ExplicitTransaction(Connection conn, SessionResourcesHandler resourcesHandler, Bookmark initialBookmark) {
        this.conn = conn;
        this.resourcesHandler = resourcesHandler;
        ExplicitTransaction.runBeginStatement(conn, initialBookmark);
    }

    @Override
    public void success() {
        if (this.state == State.ACTIVE) {
            this.state = State.MARKED_SUCCESS;
        }
    }

    @Override
    public void failure() {
        if (this.state == State.ACTIVE || this.state == State.MARKED_SUCCESS) {
            this.state = State.MARKED_FAILED;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        block11: {
            try {
                if (this.conn == null || !this.conn.isOpen()) break block11;
                if (this.state == State.MARKED_SUCCESS) {
                    try {
                        this.conn.run("COMMIT", Collections.emptyMap(), Collector.NO_OP);
                        this.conn.pullAll(new BookmarkCollector(this));
                        this.conn.sync();
                        this.state = State.SUCCEEDED;
                        break block11;
                    }
                    catch (Throwable e) {
                        try {
                            this.rollbackTx();
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        throw e;
                    }
                }
                if (this.state == State.MARKED_FAILED || this.state == State.ACTIVE) {
                    this.rollbackTx();
                } else if (this.state == State.FAILED) {
                    this.state = State.ROLLED_BACK;
                }
            }
            finally {
                this.resourcesHandler.onTransactionClosed(this);
            }
        }
    }

    private void rollbackTx() {
        this.conn.run("ROLLBACK", Collections.emptyMap(), Collector.NO_OP);
        this.conn.pullAll(new BookmarkCollector(this));
        this.conn.sync();
        this.state = State.ROLLED_BACK;
    }

    @Override
    public StatementResult run(String statementText, Value statementParameters) {
        return this.run(new Statement(statementText, statementParameters));
    }

    @Override
    public StatementResult run(String statementText) {
        return this.run(statementText, Values.EmptyMap);
    }

    @Override
    public StatementResult run(String statementText, Map<String, Object> statementParameters) {
        Value params = statementParameters == null ? Values.EmptyMap : Values.value(statementParameters);
        return this.run(statementText, params);
    }

    @Override
    public StatementResult run(String statementTemplate, Record statementParameters) {
        Value params = statementParameters == null ? Values.EmptyMap : Values.value(statementParameters.asMap());
        return this.run(statementTemplate, params);
    }

    @Override
    public synchronized StatementResult run(Statement statement) {
        this.ensureNotFailed();
        try {
            InternalStatementResult result = new InternalStatementResult(this.conn, SessionResourcesHandler.NO_OP, this, statement);
            this.conn.run(statement.text(), statement.parameters().asMap(Values.ofValue()), result.runResponseCollector());
            this.conn.pullAll(result.pullAllResponseCollector());
            this.conn.flush();
            return result;
        }
        catch (Neo4jException e) {
            this.state = State.FAILED;
            throw e;
        }
    }

    @Override
    public boolean isOpen() {
        return this.state != State.SUCCEEDED && this.state != State.ROLLED_BACK;
    }

    private void ensureNotFailed() {
        if (this.state == State.FAILED || this.state == State.MARKED_FAILED || this.state == State.ROLLED_BACK) {
            throw new ClientException("Cannot run more statements in this transaction, because previous statements in the transaction has failed and the transaction has been rolled back. Please start a new transaction to run another statement.");
        }
    }

    @Override
    public TypeSystem typeSystem() {
        return InternalTypeSystem.TYPE_SYSTEM;
    }

    public synchronized void markToClose() {
        this.state = State.FAILED;
    }

    public Bookmark bookmark() {
        return this.bookmark;
    }

    void setBookmark(Bookmark bookmark) {
        if (bookmark != null && !bookmark.isEmpty()) {
            this.bookmark = bookmark;
        }
    }

    private static void runBeginStatement(Connection connection, Bookmark bookmark) {
        Bookmark initialBookmark = bookmark == null ? Bookmark.empty() : bookmark;
        Map<String, Value> parameters = initialBookmark.asBeginTransactionParameters();
        connection.run("BEGIN", parameters, Collector.NO_OP);
        connection.pullAll(Collector.NO_OP);
        if (!initialBookmark.isEmpty()) {
            connection.sync();
        }
    }

    private static enum State {
        ACTIVE,
        MARKED_SUCCESS,
        MARKED_FAILED,
        FAILED,
        SUCCEEDED,
        ROLLED_BACK;

    }
}

