/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.summary;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.neo4j.driver.internal.spi.Collector;
import org.neo4j.driver.internal.summary.InternalSummaryCounters;
import org.neo4j.driver.v1.Statement;
import org.neo4j.driver.v1.Value;
import org.neo4j.driver.v1.exceptions.ClientException;
import org.neo4j.driver.v1.exceptions.Neo4jException;
import org.neo4j.driver.v1.summary.Notification;
import org.neo4j.driver.v1.summary.Plan;
import org.neo4j.driver.v1.summary.ProfiledPlan;
import org.neo4j.driver.v1.summary.ResultSummary;
import org.neo4j.driver.v1.summary.ServerInfo;
import org.neo4j.driver.v1.summary.StatementType;
import org.neo4j.driver.v1.summary.SummaryCounters;

public class SummaryBuilder
implements Collector {
    private final Statement statement;
    private final ServerInfo serverInfo;
    private StatementType type = null;
    private SummaryCounters statistics = null;
    private Plan plan = null;
    private ProfiledPlan profile;
    private List<Notification> notifications = null;
    private long resultAvailableAfter = -1L;
    private long resultConsumedAfter = -1L;

    public SummaryBuilder(Statement statement, ServerInfo serverInfo) {
        this.statement = statement;
        this.serverInfo = serverInfo;
    }

    @Override
    public void keys(String[] names) {
    }

    @Override
    public void record(Value[] fields) {
    }

    @Override
    public void statementType(StatementType type) {
        if (this.type != null) {
            throw new ClientException("Received statement type twice");
        }
        this.type = type;
    }

    @Override
    public void statementStatistics(SummaryCounters statistics) {
        if (this.statistics != null) {
            throw new ClientException("Received statement statistics twice");
        }
        this.statistics = statistics;
    }

    @Override
    public void plan(Plan plan) {
        if (this.plan != null) {
            throw new ClientException("Received plan twice");
        }
        this.plan = plan;
    }

    @Override
    public void profile(ProfiledPlan plan) {
        if (this.plan != null || this.profile != null) {
            throw new ClientException("Received plan twice");
        }
        this.profile = plan;
        this.plan = plan;
    }

    @Override
    public void notifications(List<Notification> notifications) {
        if (this.notifications != null) {
            throw new ClientException("Received notifications twice");
        }
        this.notifications = notifications;
    }

    @Override
    public void bookmark(String bookmark) {
    }

    @Override
    public void done() {
    }

    @Override
    public void doneSuccess() {
    }

    @Override
    public void doneFailure(Neo4jException erro) {
    }

    @Override
    public void doneIgnored() {
    }

    @Override
    public void resultAvailableAfter(long l) {
        this.resultAvailableAfter = l;
    }

    @Override
    public void resultConsumedAfter(long l) {
        this.resultConsumedAfter = l;
    }

    @Override
    public void serverVersion(String server) {
    }

    public ResultSummary build() {
        return new ResultSummary(){

            @Override
            public Statement statement() {
                return SummaryBuilder.this.statement;
            }

            @Override
            public SummaryCounters counters() {
                return SummaryBuilder.this.statistics == null ? InternalSummaryCounters.EMPTY_STATS : SummaryBuilder.this.statistics;
            }

            @Override
            public StatementType statementType() {
                return SummaryBuilder.this.type;
            }

            @Override
            public boolean hasProfile() {
                return SummaryBuilder.this.profile != null;
            }

            @Override
            public boolean hasPlan() {
                return SummaryBuilder.this.plan != null;
            }

            @Override
            public Plan plan() {
                return SummaryBuilder.this.plan;
            }

            @Override
            public ProfiledPlan profile() {
                return SummaryBuilder.this.profile;
            }

            @Override
            public List<Notification> notifications() {
                return SummaryBuilder.this.notifications == null ? new ArrayList() : SummaryBuilder.this.notifications;
            }

            @Override
            public long resultAvailableAfter(TimeUnit timeUnit) {
                return timeUnit.convert(SummaryBuilder.this.resultAvailableAfter, TimeUnit.MILLISECONDS);
            }

            @Override
            public long resultConsumedAfter(TimeUnit timeUnit) {
                return timeUnit.convert(SummaryBuilder.this.resultConsumedAfter, TimeUnit.MILLISECONDS);
            }

            @Override
            public ServerInfo server() {
                return SummaryBuilder.this.serverInfo;
            }
        };
    }
}

