/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal;

import java.util.concurrent.atomic.AtomicBoolean;
import org.neo4j.driver.internal.security.SecurityPlan;
import org.neo4j.driver.v1.AccessMode;
import org.neo4j.driver.v1.Driver;
import org.neo4j.driver.v1.Logger;
import org.neo4j.driver.v1.Logging;
import org.neo4j.driver.v1.Session;

abstract class BaseDriver
implements Driver {
    private static final String DRIVER_LOG_NAME = "Driver";
    private final SecurityPlan securityPlan;
    protected final Logger log;
    private AtomicBoolean closed = new AtomicBoolean(false);

    BaseDriver(SecurityPlan securityPlan, Logging logging) {
        this.securityPlan = securityPlan;
        this.log = logging.getLog(DRIVER_LOG_NAME);
    }

    @Override
    public final boolean isEncrypted() {
        this.assertOpen();
        return this.securityPlan.requiresEncryption();
    }

    @Override
    public final Session session() {
        return this.session(AccessMode.WRITE);
    }

    @Override
    public final Session session(AccessMode mode) {
        this.assertOpen();
        Session session = this.newSessionWithMode(mode);
        if (this.closed.get()) {
            this.closeResources();
            throw this.driverCloseException();
        }
        return session;
    }

    @Override
    public final void close() {
        if (this.closed.compareAndSet(false, true)) {
            this.closeResources();
        }
    }

    protected abstract Session newSessionWithMode(AccessMode var1);

    protected abstract void closeResources();

    private void assertOpen() {
        if (this.closed.get()) {
            throw this.driverCloseException();
        }
    }

    private IllegalStateException driverCloseException() {
        return new IllegalStateException("This driver instance has already been closed");
    }
}

