/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.net.pooling;

import java.util.HashMap;
import java.util.Map;
import org.neo4j.driver.internal.net.pooling.PoolSettings;
import org.neo4j.driver.internal.net.pooling.PooledConnection;
import org.neo4j.driver.internal.spi.Collector;
import org.neo4j.driver.internal.spi.ConnectionPool;
import org.neo4j.driver.v1.Value;
import org.neo4j.driver.v1.util.Function;

class PooledConnectionValidator
implements Function<PooledConnection, Boolean> {
    private final ConnectionPool pool;
    private final PoolSettings poolSettings;
    private static final Map<String, Value> NO_PARAMETERS = new HashMap<String, Value>();

    PooledConnectionValidator(ConnectionPool pool, PoolSettings poolSettings) {
        this.pool = pool;
        this.poolSettings = poolSettings;
    }

    @Override
    public Boolean apply(PooledConnection pooledConnection) {
        return this.pool.hasAddress(pooledConnection.address()) && !pooledConnection.hasUnrecoverableErrors() && this.reset(pooledConnection) && (pooledConnection.idleTime() <= this.poolSettings.idleTimeBeforeConnectionTest() || this.ping(pooledConnection));
    }

    private boolean reset(PooledConnection conn) {
        try {
            conn.reset();
            conn.sync();
            return true;
        }
        catch (Throwable e) {
            return false;
        }
    }

    private boolean ping(PooledConnection conn) {
        try {
            conn.run("RETURN 1 // JavaDriver poll to test connection", NO_PARAMETERS, Collector.NO_OP);
            conn.pullAll(Collector.NO_OP);
            conn.sync();
            return true;
        }
        catch (Throwable e) {
            return false;
        }
    }
}

