/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal;

import org.neo4j.driver.internal.ClusteredErrorHandler;
import org.neo4j.driver.internal.ClusteredStatementResult;
import org.neo4j.driver.internal.NetworkSession;
import org.neo4j.driver.internal.net.BoltServerAddress;
import org.neo4j.driver.internal.spi.Connection;
import org.neo4j.driver.v1.Logger;
import org.neo4j.driver.v1.Statement;
import org.neo4j.driver.v1.StatementResult;
import org.neo4j.driver.v1.exceptions.ClientException;
import org.neo4j.driver.v1.exceptions.ConnectionFailureException;
import org.neo4j.driver.v1.exceptions.SessionExpiredException;

public class ClusteredNetworkSession
extends NetworkSession {
    private final ClusteredErrorHandler onError;

    ClusteredNetworkSession(Connection connection, ClusteredErrorHandler onError, Logger logger) {
        super(connection, logger);
        this.onError = onError;
    }

    @Override
    public StatementResult run(Statement statement) {
        try {
            return new ClusteredStatementResult(super.run(statement), this.connection.address(), this.onError);
        }
        catch (ConnectionFailureException e) {
            this.onError.onConnectionFailure(this.connection.address());
            throw new SessionExpiredException("Failed to perform write load to server", e);
        }
        catch (ClientException e) {
            if (e.code().equals("Neo.ClientError.Cluster.NotALeader")) {
                this.onError.onWriteFailure(this.connection.address());
                throw new SessionExpiredException(String.format("Server at %s no longer accepts writes", this.connection.address().toString()));
            }
            throw e;
        }
    }

    @Override
    public void close() {
        try {
            super.close();
        }
        catch (ConnectionFailureException e) {
            BoltServerAddress address = this.connection.address();
            this.onError.onConnectionFailure(address);
            throw new SessionExpiredException(String.format("Server at %s is no longer available", address.toString()), e);
        }
    }
}

