/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.value;

import org.neo4j.driver.internal.value.InternalValue;
import org.neo4j.driver.internal.value.ValueAdapter;

public abstract class GraphValueAdapter<V>
extends ValueAdapter {
    private final V adapted;

    protected GraphValueAdapter(V adapted) {
        if (adapted == null) {
            throw new IllegalArgumentException(String.format("Cannot construct %s from null", this.getClass().getSimpleName()));
        }
        this.adapted = adapted;
    }

    public V asObject() {
        return this.adapted;
    }

    @Override
    public String toString(InternalValue.Format valueFormat) {
        return this.maybeWithType(valueFormat.includeType(), this.adapted.toString());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GraphValueAdapter values = (GraphValueAdapter)o;
        return this.adapted.equals(values.adapted);
    }

    @Override
    public int hashCode() {
        return this.adapted.hashCode();
    }
}

