/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal;

import java.net.URI;
import org.neo4j.driver.internal.InternalSession;
import org.neo4j.driver.internal.pool.InternalConnectionPool;
import org.neo4j.driver.internal.spi.ConnectionPool;
import org.neo4j.driver.internal.util.AddressUtil;
import org.neo4j.driver.v1.AuthToken;
import org.neo4j.driver.v1.Config;
import org.neo4j.driver.v1.Driver;
import org.neo4j.driver.v1.Session;
import org.neo4j.driver.v1.exceptions.ClientException;
import org.neo4j.driver.v1.exceptions.Neo4jException;

public class InternalDriver
implements Driver {
    private final ConnectionPool connections;
    private final URI url;
    private final Config config;

    public InternalDriver(URI url, AuthToken authToken, Config config) {
        this.url = url;
        this.connections = new InternalConnectionPool(config, authToken);
        this.config = config;
    }

    @Override
    public boolean isEncrypted() {
        Config.EncryptionLevel encryptionLevel = this.config.encryptionLevel();
        return encryptionLevel.equals((Object)Config.EncryptionLevel.REQUIRED) || encryptionLevel.equals((Object)Config.EncryptionLevel.REQUIRED_NON_LOCAL) && !AddressUtil.isLocalHost(this.url.getHost());
    }

    @Override
    public Session session() {
        return new InternalSession(this.connections.acquire(this.url), this.config.logging().getLog("session"));
    }

    @Override
    public void close() throws Neo4jException {
        try {
            this.connections.close();
        }
        catch (Exception e) {
            throw new ClientException("Failed to close driver.", e);
        }
    }
}

