/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.pool;

import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.ServiceLoader;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.neo4j.driver.internal.connector.socket.SocketConnector;
import org.neo4j.driver.internal.pool.PooledConnection;
import org.neo4j.driver.internal.pool.PooledConnectionReleaseConsumer;
import org.neo4j.driver.internal.spi.Connection;
import org.neo4j.driver.internal.spi.ConnectionPool;
import org.neo4j.driver.internal.spi.Connector;
import org.neo4j.driver.internal.util.Clock;
import org.neo4j.driver.v1.AuthToken;
import org.neo4j.driver.v1.Config;
import org.neo4j.driver.v1.exceptions.ClientException;
import org.neo4j.driver.v1.exceptions.Neo4jException;

public class InternalConnectionPool
implements ConnectionPool {
    private final ConcurrentHashMap<String, Connector> connectors = new ConcurrentHashMap();
    private final ConcurrentHashMap<URI, BlockingQueue<PooledConnection>> pools = new ConcurrentHashMap();
    private final AuthToken authToken;
    private final Clock clock;
    private final Config config;
    private final AtomicBoolean stopped = new AtomicBoolean(false);

    public InternalConnectionPool(Config config, AuthToken authToken) {
        this(InternalConnectionPool.loadConnectors(), Clock.SYSTEM, config, authToken);
    }

    public InternalConnectionPool(Collection<Connector> conns, Clock clock, Config config, AuthToken authToken) {
        this.authToken = authToken;
        this.config = config;
        this.clock = clock;
        for (Connector connector : conns) {
            for (String s : connector.supportedSchemes()) {
                this.connectors.put(s, connector);
            }
        }
    }

    @Override
    public Connection acquire(URI sessionURI) {
        if (this.stopped.get()) {
            throw new IllegalStateException("Pool has been closed, cannot acquire new values.");
        }
        BlockingQueue<PooledConnection> connections = this.pool(sessionURI);
        PooledConnection conn = (PooledConnection)connections.poll();
        if (conn == null) {
            Connector connector = this.connectors.get(sessionURI.getScheme());
            if (connector == null) {
                throw new ClientException(String.format("Unsupported URI scheme: '%s' in url: '%s'. Supported transports are: '%s'.", sessionURI.getScheme(), sessionURI, this.connectorSchemes()));
            }
            conn = new PooledConnection(connector.connect(sessionURI, this.config, this.authToken), new PooledConnectionReleaseConsumer(connections, this.stopped, this.config), this.clock);
        }
        conn.updateUsageTimestamp();
        return conn;
    }

    private BlockingQueue<PooledConnection> pool(URI sessionURI) {
        BlockingQueue<PooledConnection> pool = this.pools.get(sessionURI);
        if (pool == null && this.pools.putIfAbsent(sessionURI, pool = new LinkedBlockingQueue<PooledConnection>(this.config.maxIdleConnectionPoolSize())) != null) {
            return this.pool(sessionURI);
        }
        return pool;
    }

    private static Collection<Connector> loadConnectors() {
        LinkedList<Connector> connectors = new LinkedList<Connector>();
        SocketConnector conn = new SocketConnector();
        connectors.add(conn);
        ServiceLoader<Connector> load = ServiceLoader.load(Connector.class);
        for (Connector connector : load) {
            connectors.add(connector);
        }
        return connectors;
    }

    @Override
    public void close() throws Neo4jException {
        if (!this.stopped.compareAndSet(false, true)) {
            return;
        }
        for (BlockingQueue<PooledConnection> pool : this.pools.values()) {
            while (!pool.isEmpty()) {
                PooledConnection conn = (PooledConnection)pool.poll();
                if (conn == null) continue;
                conn.dispose();
            }
        }
        this.pools.clear();
    }

    private String connectorSchemes() {
        return Arrays.toString(this.connectors.keySet().toArray(new String[this.connectors.keySet().size()]));
    }
}

