/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.connector.socket;

import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.neo4j.driver.internal.Version;
import org.neo4j.driver.internal.auth.InternalAuthToken;
import org.neo4j.driver.internal.connector.ConcurrencyGuardingConnection;
import org.neo4j.driver.internal.connector.socket.SocketConnection;
import org.neo4j.driver.internal.spi.Connection;
import org.neo4j.driver.internal.spi.Connector;
import org.neo4j.driver.v1.AuthToken;
import org.neo4j.driver.v1.AuthTokens;
import org.neo4j.driver.v1.Config;
import org.neo4j.driver.v1.Value;
import org.neo4j.driver.v1.exceptions.ClientException;

public class SocketConnector
implements Connector {
    public static final String SCHEME = "bolt";
    public static final int DEFAULT_PORT = 7687;

    @Override
    public boolean supports(String scheme) {
        return scheme.equals(SCHEME);
    }

    @Override
    public Connection connect(URI sessionURI, Config config, AuthToken authToken) throws ClientException {
        int port = sessionURI.getPort() == -1 ? 7687 : sessionURI.getPort();
        Connection conn = new SocketConnection(sessionURI.getHost(), port, config);
        conn = new ConcurrencyGuardingConnection(conn);
        conn.init("bolt-java-driver/" + Version.driverVersion(), this.tokenAsMap(authToken));
        return conn;
    }

    @Override
    public Collection<String> supportedSchemes() {
        return Collections.singletonList(SCHEME);
    }

    private Map<String, Value> tokenAsMap(AuthToken token) {
        if (token instanceof InternalAuthToken) {
            return ((InternalAuthToken)token).toMap();
        }
        throw new ClientException("Unknown authentication token, `" + token + "`. Please use one of the supported " + "tokens from `" + AuthTokens.class.getSimpleName() + "`.");
    }
}

