/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.util;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;

public class BytePrinter {
    public static void print(byte[] bytes, PrintStream out) {
        BytePrinter.print(ByteBuffer.wrap(bytes), out, 0, bytes.length);
    }

    public static void print(ByteBuffer bytes, PrintStream out) {
        BytePrinter.print(bytes, out, 0, bytes.limit());
    }

    public static void print(ByteBuffer bytes, PrintStream out, int offset, int length) {
        for (int i = offset; i < offset + length; ++i) {
            BytePrinter.print(bytes.get(i), out);
            if ((i - offset + 1) % 32 == 0) {
                out.println();
                continue;
            }
            if ((i - offset + 1) % 8 == 0) {
                out.print("    ");
                continue;
            }
            out.print(" ");
        }
    }

    public static void print(byte b, PrintStream out) {
        out.print(BytePrinter.hex(b));
    }

    public static String ljust(String str, int columnWidth) {
        return String.format("%-" + columnWidth + "s", str);
    }

    public static String rjust(String str, int columnWidth) {
        return String.format("%" + columnWidth + "s", str);
    }

    public static String hex(byte b) {
        return String.format("%02x", b);
    }

    public static String hex(ByteBuffer bytes, int offset, int length) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            PrintStream ps = new PrintStream((OutputStream)baos, true, "UTF-8");
            BytePrinter.print(bytes, ps, offset, length);
            return baos.toString("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String hex(ByteBuffer bytes) {
        return BytePrinter.hex(bytes, 0, bytes.limit());
    }

    public static String hex(byte[] bytes) {
        return BytePrinter.hex(ByteBuffer.wrap(bytes));
    }

    public static String compactHex(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (byte b : bytes) {
            sb.append(BytePrinter.hex(b));
        }
        return sb.toString();
    }

    public static byte[] hexStringToBytes(String s) {
        int len = s.length();
        ByteArrayOutputStream data = new ByteArrayOutputStream(1024);
        int i = 0;
        while (i < len) {
            int firstDigit = Character.digit(s.charAt(i), 16);
            if (firstDigit != -1) {
                int secondDigit = Character.digit(s.charAt(i + 1), 16);
                int toWrite = (firstDigit << 4) + secondDigit;
                data.write(toWrite);
                i += 2;
                continue;
            }
            ++i;
        }
        return data.toByteArray();
    }

    public static String hexInOneLine(ByteBuffer bytes, int offset, int length) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            PrintStream out = new PrintStream((OutputStream)baos, true, "UTF-8");
            for (int i = offset; i < offset + length; ++i) {
                BytePrinter.print(bytes.get(i), out);
                if (i == offset + length - 1) continue;
                if ((i - offset + 1) % 8 == 0) {
                    out.print("    ");
                    continue;
                }
                out.print(" ");
            }
            return baos.toString("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }
}

