/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal;

import java.util.Map;
import org.neo4j.driver.internal.InternalStatementResult;
import org.neo4j.driver.internal.InternalTransaction;
import org.neo4j.driver.internal.spi.Connection;
import org.neo4j.driver.internal.spi.Logger;
import org.neo4j.driver.internal.types.InternalTypeSystem;
import org.neo4j.driver.v1.Record;
import org.neo4j.driver.v1.Session;
import org.neo4j.driver.v1.Statement;
import org.neo4j.driver.v1.StatementResult;
import org.neo4j.driver.v1.Transaction;
import org.neo4j.driver.v1.Value;
import org.neo4j.driver.v1.Values;
import org.neo4j.driver.v1.exceptions.ClientException;
import org.neo4j.driver.v1.types.TypeSystem;

public class InternalSession
implements Session {
    private final Connection connection;
    private final Logger logger;
    private final Runnable txCleanup = new Runnable(){

        @Override
        public void run() {
            InternalSession.this.currentTransaction = null;
        }
    };
    private InternalTransaction currentTransaction;
    private boolean isOpen = true;

    public InternalSession(Connection connection, Logger logger) {
        this.connection = connection;
        this.logger = logger;
    }

    @Override
    public StatementResult run(String statementText) {
        return this.run(statementText, Values.EmptyMap);
    }

    @Override
    public StatementResult run(String statementText, Map<String, Object> statementParameters) {
        return this.run(statementText, Values.value(statementParameters));
    }

    @Override
    public StatementResult run(String statementTemplate, Record statementParameters) {
        return this.run(statementTemplate, statementParameters.asMap());
    }

    @Override
    public StatementResult run(String statementText, Value statementParameters) {
        return this.run(new Statement(statementText, statementParameters));
    }

    @Override
    public StatementResult run(Statement statement) {
        this.ensureConnectionIsValid();
        InternalStatementResult cursor = new InternalStatementResult(this.connection, statement);
        this.connection.run(statement.text(), statement.parameters().asMap(Values.ofValue()), cursor.runResponseCollector());
        this.connection.pullAll(cursor.pullAllResponseCollector());
        this.connection.flush();
        return cursor;
    }

    @Override
    public boolean isOpen() {
        return this.isOpen;
    }

    @Override
    public void close() {
        if (!this.isOpen) {
            throw new ClientException("This session has already been closed.");
        }
        this.isOpen = false;
        if (this.currentTransaction != null) {
            try {
                this.currentTransaction.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.connection.sync();
        this.connection.close();
    }

    @Override
    public Transaction beginTransaction() {
        this.ensureConnectionIsValid();
        this.currentTransaction = new InternalTransaction(this.connection, this.txCleanup);
        this.connection.onError(new Runnable(){

            @Override
            public void run() {
                if (InternalSession.this.currentTransaction != null) {
                    InternalSession.this.currentTransaction.markAsRolledBack();
                    InternalSession.this.currentTransaction = null;
                    InternalSession.this.connection.onError(null);
                }
            }
        });
        return this.currentTransaction;
    }

    @Override
    public TypeSystem typeSystem() {
        return InternalTypeSystem.TYPE_SYSTEM;
    }

    private void ensureConnectionIsValid() {
        this.ensureNoOpenTransaction();
        this.ensureConnectionIsOpen();
    }

    protected void finalize() throws Throwable {
        if (this.isOpen) {
            this.logger.error("Neo4j Session object leaked, please ensure that your application calls the `close` method on Sessions before disposing of the objects.", null);
            this.connection.close();
        }
        super.finalize();
    }

    private void ensureNoOpenTransaction() {
        if (this.currentTransaction != null) {
            throw new ClientException("Please close the currently open transaction object before running more statements/transactions in the current session.");
        }
    }

    private void ensureConnectionIsOpen() {
        if (!this.connection.isOpen()) {
            throw new ClientException("The current session cannot be reused as the underlying connection with the server has been closed due to unrecoverable errors. Please close this session and retry your statement in another new session.");
        }
    }
}

