/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.connector.socket;

import java.io.IOException;
import java.net.SocketTimeoutException;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import org.neo4j.driver.internal.connector.socket.LoggingResponseHandler;
import org.neo4j.driver.internal.connector.socket.SocketClient;
import org.neo4j.driver.internal.connector.socket.SocketResponseHandler;
import org.neo4j.driver.internal.messaging.DiscardAllMessage;
import org.neo4j.driver.internal.messaging.InitMessage;
import org.neo4j.driver.internal.messaging.Message;
import org.neo4j.driver.internal.messaging.PullAllMessage;
import org.neo4j.driver.internal.messaging.ResetMessage;
import org.neo4j.driver.internal.messaging.RunMessage;
import org.neo4j.driver.internal.spi.Connection;
import org.neo4j.driver.internal.spi.Logger;
import org.neo4j.driver.internal.spi.StreamCollector;
import org.neo4j.driver.v1.Config;
import org.neo4j.driver.v1.Value;
import org.neo4j.driver.v1.exceptions.ClientException;
import org.neo4j.driver.v1.exceptions.Neo4jException;

public class SocketConnection
implements Connection {
    private final Logger logger;
    private final Queue<Message> pendingMessages = new LinkedList<Message>();
    private final SocketResponseHandler responseHandler;
    private final SocketClient socket;

    public SocketConnection(String host, int port, Config config) {
        this.logger = config.logging().getLog(this.getClass().getName());
        this.responseHandler = this.logger.isDebugEnabled() ? new LoggingResponseHandler(this.logger) : new SocketResponseHandler();
        this.socket = new SocketClient(host, port, config, this.logger);
        this.socket.start();
    }

    @Override
    public void init(String clientName) {
        this.queueMessage(new InitMessage(clientName), StreamCollector.NO_OP);
    }

    @Override
    public void run(String statement, Map<String, Value> parameters, StreamCollector collector) {
        this.queueMessage(new RunMessage(statement, parameters), collector);
    }

    @Override
    public void discardAll() {
        this.queueMessage(DiscardAllMessage.DISCARD_ALL, StreamCollector.NO_OP);
    }

    @Override
    public void pullAll(StreamCollector collector) {
        this.queueMessage(PullAllMessage.PULL_ALL, collector);
    }

    @Override
    public void reset(StreamCollector collector) {
        this.queueMessage(ResetMessage.RESET, collector);
    }

    @Override
    public void sync() {
        if (this.sendAll() > 0) {
            this.receiveAll();
        }
    }

    @Override
    public int sendAll() {
        try {
            return this.socket.sendAll(this.pendingMessages);
        }
        catch (IOException e) {
            String message = e.getMessage();
            throw new ClientException("Unable to send messages to server: " + message, e);
        }
    }

    @Override
    public int receiveAll() {
        try {
            int messageCount = this.socket.receiveAll(this.responseHandler);
            if (this.responseHandler.serverFailureOccurred()) {
                this.reset(StreamCollector.NO_OP);
                Neo4jException exception = this.responseHandler.serverFailure();
                this.responseHandler.clearError();
                throw exception;
            }
            return messageCount;
        }
        catch (IOException e) {
            String message = e.getMessage();
            if (message == null) {
                throw new ClientException("Unable to read response from server: " + e.getClass().getSimpleName(), e);
            }
            if (e instanceof SocketTimeoutException) {
                throw new ClientException("Server did not reply within the network timeout limit.", e);
            }
            throw new ClientException("Unable to read response from server: " + message, e);
        }
    }

    @Override
    public void receiveOne() {
        try {
            this.socket.receiveOne(this.responseHandler);
            if (this.responseHandler.serverFailureOccurred()) {
                this.reset(StreamCollector.NO_OP);
                Neo4jException exception = this.responseHandler.serverFailure();
                this.responseHandler.clearError();
                throw exception;
            }
        }
        catch (IOException e) {
            String message = e.getMessage();
            if (message == null) {
                throw new ClientException("Unable to read response from server: " + e.getClass().getSimpleName(), e);
            }
            if (e instanceof SocketTimeoutException) {
                throw new ClientException("Server did not reply within the network timeout limit.", e);
            }
            throw new ClientException("Unable to read response from server: " + message, e);
        }
    }

    private void queueMessage(Message msg, StreamCollector collector) {
        this.pendingMessages.add(msg);
        this.responseHandler.appendResultCollector(collector);
    }

    @Override
    public void close() {
        this.socket.stop();
    }

    @Override
    public boolean isOpen() {
        return this.socket.isOpen();
    }
}

