/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.connector.socket;

import java.io.IOException;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.ByteChannel;
import java.nio.channels.SocketChannel;
import java.security.GeneralSecurityException;
import java.util.Queue;
import org.neo4j.driver.internal.connector.socket.AllOrNothingChannel;
import org.neo4j.driver.internal.connector.socket.LoggingByteChannel;
import org.neo4j.driver.internal.connector.socket.SSLSocketChannel;
import org.neo4j.driver.internal.connector.socket.SocketProtocol;
import org.neo4j.driver.internal.connector.socket.SocketProtocolV1;
import org.neo4j.driver.internal.connector.socket.SocketResponseHandler;
import org.neo4j.driver.internal.messaging.Message;
import org.neo4j.driver.internal.messaging.MessageFormat;
import org.neo4j.driver.internal.spi.Logger;
import org.neo4j.driver.v1.Config;
import org.neo4j.driver.v1.exceptions.ClientException;

public class SocketClient {
    private static final int MAGIC_PREAMBLE = 1616949271;
    private static final int VERSION1 = 1;
    private static final int NO_VERSION = 0;
    private static final int[] SUPPORTED_VERSIONS = new int[]{1, 0, 0, 0};
    private final String host;
    private final int port;
    private final Logger logger;
    protected final Config config;
    private SocketProtocol protocol;
    private MessageFormat.Reader reader;
    private MessageFormat.Writer writer;
    private ByteChannel channel;

    public SocketClient(String host, int port, Config config, Logger logger) {
        this.host = host;
        this.port = port;
        this.config = config;
        this.logger = logger;
        this.channel = null;
    }

    public void start() {
        try {
            this.logger.debug("~~ [CONNECT] %s:%d.", this.host, this.port);
            this.channel = ChannelFactory.create(this.host, this.port, this.config, this.logger);
            this.protocol = this.negotiateProtocol();
            this.reader = this.protocol.reader();
            this.writer = this.protocol.writer();
        }
        catch (ConnectException e) {
            throw new ClientException(String.format("Unable to connect to '%s' on port %s, ensure the database is running and that there is a working network connection to it.", this.host, this.port));
        }
        catch (IOException e) {
            throw new ClientException("Unable to process request: " + e.getMessage(), e);
        }
        catch (GeneralSecurityException e) {
            throw new ClientException("Unable to establish ssl connection with server: " + e.getMessage(), e);
        }
    }

    public int sendAll(Queue<Message> messages) throws IOException {
        Message message;
        int messageCount = 0;
        while ((message = messages.poll()) != null) {
            this.logger.debug("C: %s", message);
            this.writer.write(message);
            ++messageCount;
        }
        if (messageCount > 0) {
            this.writer.flush();
        }
        return messageCount;
    }

    public int receiveAll(SocketResponseHandler handler) throws IOException {
        int messageCount = handler.collectorsWaiting();
        while (handler.collectorsWaiting() > 0) {
            this.receiveOne(handler);
        }
        return messageCount;
    }

    public void receiveOne(SocketResponseHandler handler) throws IOException {
        this.reader.read(handler);
        if (handler.protocolViolationErrorOccurred()) {
            this.stop();
            throw handler.serverFailure();
        }
    }

    public void stop() {
        block3: {
            try {
                if (this.channel != null) {
                    this.logger.debug("~~ [CLOSE]", new Object[0]);
                    this.channel.close();
                    this.channel = null;
                }
            }
            catch (IOException e) {
                if (e.getMessage().equals("An existing connection was forcibly closed by the remote host")) break block3;
                throw new ClientException("Unable to close socket connection properly." + e.getMessage(), e);
            }
        }
    }

    public boolean isOpen() {
        return this.channel != null && this.channel.isOpen();
    }

    private SocketProtocol negotiateProtocol() throws IOException {
        this.logger.debug("~~ [HANDSHAKE] [0x6060B017, 1, 0, 0, 0].", new Object[0]);
        ByteBuffer buf = ByteBuffer.allocate(20).order(ByteOrder.BIG_ENDIAN);
        buf.putInt(1616949271);
        for (int version : SUPPORTED_VERSIONS) {
            buf.putInt(version);
        }
        buf.flip();
        this.channel.write(buf);
        buf.clear();
        buf.limit(4);
        this.channel.read(buf);
        buf.flip();
        int proposal = buf.getInt();
        switch (proposal) {
            case 1: {
                this.logger.debug("~~ [HANDSHAKE] 1", new Object[0]);
                return new SocketProtocolV1(this.channel);
            }
            case 0: {
                throw new ClientException("The server does not support any of the protocol versions supported by this driver. Ensure that you are using driver and server versions that are compatible with one another.");
            }
        }
        throw new ClientException("Protocol error, server suggested unexpected protocol version: " + proposal);
    }

    public String toString() {
        int version = this.protocol == null ? -1 : this.protocol.version();
        return "SocketClient[protocolVersion=" + version + "]";
    }

    private static class ChannelFactory {
        private ChannelFactory() {
        }

        public static ByteChannel create(String host, int port, Config config, Logger logger) throws IOException, GeneralSecurityException {
            SocketChannel soChannel = SocketChannel.open();
            soChannel.setOption((SocketOption)StandardSocketOptions.SO_REUSEADDR, (Object)true);
            soChannel.setOption((SocketOption)StandardSocketOptions.SO_KEEPALIVE, (Object)true);
            soChannel.connect(new InetSocketAddress(host, port));
            ByteChannel channel = null;
            channel = config.isTlsEnabled() ? new SSLSocketChannel(host, port, soChannel, logger, config.tlsAuthConfig()) : new AllOrNothingChannel(soChannel);
            if (logger.isTraceEnabled()) {
                channel = new LoggingByteChannel(channel, logger);
            }
            return channel;
        }
    }
}

