/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.connector.socket;

import java.util.Arrays;
import java.util.Map;
import org.neo4j.driver.internal.connector.socket.SocketResponseHandler;
import org.neo4j.driver.internal.messaging.DiscardAllMessage;
import org.neo4j.driver.internal.messaging.IgnoredMessage;
import org.neo4j.driver.internal.messaging.PullAllMessage;
import org.neo4j.driver.internal.messaging.ResetMessage;
import org.neo4j.driver.internal.spi.Logger;
import org.neo4j.driver.v1.Value;

public class LoggingResponseHandler
extends SocketResponseHandler {
    private static final String DEFAULT_DEBUG_LOGGING_FORMAT = "S: %s";
    private final Logger logger;

    public LoggingResponseHandler(Logger logger) {
        this.logger = logger;
    }

    @Override
    public void handleInitMessage(String clientNameAndVersion) {
        super.handleInitMessage(clientNameAndVersion);
        this.logger.debug("S: [INIT \"%s\"]", clientNameAndVersion);
    }

    @Override
    public void handleRunMessage(String statement, Map<String, Value> parameters) {
        super.handleRunMessage(statement, parameters);
        this.logger.debug("S: [RUN \"%s\" %s]", statement, parameters);
    }

    @Override
    public void handlePullAllMessage() {
        super.handlePullAllMessage();
        this.logger.debug(DEFAULT_DEBUG_LOGGING_FORMAT, PullAllMessage.PULL_ALL);
    }

    @Override
    public void handleDiscardAllMessage() {
        super.handleDiscardAllMessage();
        this.logger.debug(DEFAULT_DEBUG_LOGGING_FORMAT, DiscardAllMessage.DISCARD_ALL);
    }

    @Override
    public void handleResetMessage() {
        super.handleResetMessage();
        this.logger.debug(DEFAULT_DEBUG_LOGGING_FORMAT, ResetMessage.RESET);
    }

    @Override
    public void handleSuccessMessage(Map<String, Value> meta) {
        super.handleSuccessMessage(meta);
        this.logger.debug("S: [SUCCESS %s]", meta);
    }

    @Override
    public void handleRecordMessage(Value[] fields) {
        super.handleRecordMessage(fields);
        this.logger.debug("S: [RECORD %s]", Arrays.asList(fields));
    }

    @Override
    public void handleFailureMessage(String code, String message) {
        super.handleFailureMessage(code, message);
        this.logger.debug("S: [FAILURE %s \"%s\"]", code, message);
    }

    @Override
    public void handleIgnoredMessage() {
        super.handleIgnoredMessage();
        this.logger.debug(DEFAULT_DEBUG_LOGGING_FORMAT, IgnoredMessage.IGNORED);
    }
}

