/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal;

import java.util.Collections;
import java.util.Map;
import org.neo4j.driver.internal.Identities;
import org.neo4j.driver.internal.InternalEntity;
import org.neo4j.driver.internal.value.RelationshipValue;
import org.neo4j.driver.v1.Identity;
import org.neo4j.driver.v1.Relationship;
import org.neo4j.driver.v1.Value;

public class InternalRelationship
extends InternalEntity
implements Relationship {
    private Identity start;
    private Identity end;
    private final String type;

    public InternalRelationship(long id, long start, long end, String type) {
        this(Identities.identity(id), Identities.identity(start), Identities.identity(end), type, Collections.emptyMap());
    }

    public InternalRelationship(long id, long start, long end, String type, Map<String, Value> properties) {
        this(Identities.identity(id), Identities.identity(start), Identities.identity(end), type, properties);
    }

    public InternalRelationship(Identity id, Identity start, Identity end, String type, Map<String, Value> properties) {
        super(id, properties);
        this.start = start;
        this.end = end;
        this.type = type;
    }

    @Override
    public boolean hasType(String relationshipType) {
        return this.type().equals(relationshipType);
    }

    public void setStartAndEnd(Identity start, Identity end) {
        this.start = start;
        this.end = end;
    }

    @Override
    public Identity start() {
        return this.start;
    }

    @Override
    public Identity end() {
        return this.end;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public Value asValue() {
        return new RelationshipValue(this);
    }

    @Override
    public String toString() {
        return String.format("relationship<%s>", this.identity());
    }
}

