/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.summary;

import java.util.List;
import java.util.Map;
import org.neo4j.driver.internal.summary.InternalPlan;
import org.neo4j.driver.v1.Function;
import org.neo4j.driver.v1.ProfiledPlan;
import org.neo4j.driver.v1.Value;

public class InternalProfiledPlan
extends InternalPlan<ProfiledPlan>
implements ProfiledPlan {
    private final long dbHits;
    private final long records;
    public static final InternalPlan.PlanCreator<ProfiledPlan> PROFILED_PLAN = new InternalPlan.PlanCreator<ProfiledPlan>(){

        @Override
        public ProfiledPlan create(String operatorType, Map<String, Value> arguments, List<String> identifiers, List<ProfiledPlan> children, Value originalPlanValue) {
            return new InternalProfiledPlan(operatorType, arguments, identifiers, children, originalPlanValue.get("dbHits").asLong(), originalPlanValue.get("rows").asLong());
        }
    };
    public static final Function<Value, ProfiledPlan> PROFILED_PLAN_FROM_VALUE = new InternalPlan.Converter<ProfiledPlan>(PROFILED_PLAN);

    protected InternalProfiledPlan(String operatorType, Map<String, Value> arguments, List<String> identifiers, List<ProfiledPlan> children, long dbHits, long records) {
        super(operatorType, arguments, identifiers, children);
        this.dbHits = dbHits;
        this.records = records;
    }

    @Override
    public long dbHits() {
        return this.dbHits;
    }

    @Override
    public long records() {
        return this.records;
    }
}

