/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.summary;

import org.neo4j.driver.internal.summary.InternalInputPosition;
import org.neo4j.driver.v1.Function;
import org.neo4j.driver.v1.InputPosition;
import org.neo4j.driver.v1.Notification;
import org.neo4j.driver.v1.Value;

public class InternalNotification
implements Notification {
    public static final Function<Value, Notification> VALUE_TO_NOTIFICATION = new Function<Value, Notification>(){

        @Override
        public Notification apply(Value value) {
            String code = value.get("code").asString();
            String title = value.get("title").asString();
            String description = value.get("description").asString();
            Value posValue = value.get("position");
            InternalInputPosition position = null;
            if (posValue != null) {
                position = new InternalInputPosition(posValue.get("offset").asInt(), posValue.get("line").asInt(), posValue.get("column").asInt());
            }
            return new InternalNotification(code, title, description, position);
        }
    };
    private final String code;
    private final String title;
    private final String description;
    private final InputPosition position;

    public InternalNotification(String code, String title, String description, InputPosition position) {
        this.code = code;
        this.title = title;
        this.description = description;
        this.position = position;
    }

    @Override
    public String code() {
        return this.code;
    }

    @Override
    public String title() {
        return this.title;
    }

    @Override
    public String description() {
        return this.description;
    }

    @Override
    public InputPosition position() {
        return this.position;
    }

    public String toString() {
        String info = "code=" + this.code + ", title=" + this.title + ", description=" + this.description;
        return this.position == null ? info : info + ", position={" + this.position + "}";
    }
}

