/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal;

import java.util.Iterator;
import java.util.NoSuchElementException;

public class PeekingIterator<T>
implements Iterator<T> {
    private Iterator<T> iterator;
    private T cached;

    public PeekingIterator(Iterator<T> iterator) {
        this.iterator = iterator.hasNext() ? iterator : null;
    }

    public T peek() {
        return this.cacheNext() ? (T)this.cached : null;
    }

    @Override
    public boolean hasNext() {
        return this.cacheNext();
    }

    @Override
    public T next() {
        if (this.cacheNext()) {
            T result = this.cached;
            this.cached = null;
            return result;
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private boolean cacheNext() {
        if (this.cached == null) {
            if (this.iterator == null) {
                return false;
            }
            this.cached = this.iterator.next();
            if (!this.iterator.hasNext()) {
                this.iterator = null;
            }
            return true;
        }
        return true;
    }

    public void discard() {
        this.cached = null;
        this.iterator = null;
    }
}

