/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal;

import java.util.Collections;
import java.util.Map;
import org.neo4j.driver.internal.ParameterSupport;
import org.neo4j.driver.internal.spi.Connection;
import org.neo4j.driver.internal.summary.ResultBuilder;
import org.neo4j.driver.internal.types.InternalTypeSystem;
import org.neo4j.driver.v1.ResultCursor;
import org.neo4j.driver.v1.Statement;
import org.neo4j.driver.v1.Transaction;
import org.neo4j.driver.v1.TypeSystem;
import org.neo4j.driver.v1.Value;
import org.neo4j.driver.v1.exceptions.ClientException;
import org.neo4j.driver.v1.exceptions.Neo4jException;

public class InternalTransaction
implements Transaction {
    private final Connection conn;
    private final Runnable cleanup;
    private State state = State.ACTIVE;

    public InternalTransaction(Connection conn, Runnable cleanup) {
        this.conn = conn;
        this.cleanup = cleanup;
        conn.run("BEGIN", Collections.emptyMap(), null);
        conn.discardAll();
    }

    @Override
    public void success() {
        if (this.state == State.ACTIVE) {
            this.state = State.MARKED_SUCCESS;
        }
    }

    @Override
    public void failure() {
        if (this.state == State.ACTIVE || this.state == State.MARKED_SUCCESS) {
            this.state = State.MARKED_FAILED;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        try {
            if (this.state == State.MARKED_SUCCESS) {
                this.conn.run("COMMIT", Collections.emptyMap(), null);
                this.conn.discardAll();
                this.conn.sync();
                this.state = State.SUCCEEDED;
            } else if (this.state == State.MARKED_FAILED || this.state == State.ACTIVE) {
                this.conn.run("ROLLBACK", Collections.emptyMap(), null);
                this.conn.discardAll();
                this.state = State.ROLLED_BACK;
            }
        }
        finally {
            this.cleanup.run();
        }
    }

    @Override
    public ResultCursor run(String statementText, Map<String, Value> statementParameters) {
        this.ensureNotFailed();
        try {
            ResultBuilder resultBuilder = new ResultBuilder(statementText, statementParameters);
            this.conn.run(statementText, statementParameters, resultBuilder);
            this.conn.pullAll(resultBuilder);
            this.conn.sync();
            return resultBuilder.build();
        }
        catch (Neo4jException e) {
            this.state = State.FAILED;
            throw e;
        }
    }

    @Override
    public ResultCursor run(String statementTemplate) {
        return this.run(statementTemplate, ParameterSupport.NO_PARAMETERS);
    }

    @Override
    public ResultCursor run(Statement statement) {
        return this.run(statement.template(), statement.parameters());
    }

    @Override
    public boolean isOpen() {
        return this.state == State.ACTIVE;
    }

    private void ensureNotFailed() {
        if (this.state == State.FAILED) {
            throw new ClientException("Cannot run more statements in this transaction, because previous statements in the transaction has failed and the transaction has been rolled back. Please start a new transaction to run another statement.");
        }
    }

    @Override
    public TypeSystem typeSystem() {
        return InternalTypeSystem.TYPE_SYSTEM;
    }

    private static enum State {
        ACTIVE,
        MARKED_SUCCESS,
        MARKED_FAILED,
        FAILED,
        SUCCEEDED,
        ROLLED_BACK;

    }
}

