/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.value;

import org.neo4j.driver.internal.value.ValueAdapter;

public class IntegerValue
extends ValueAdapter {
    private final long val;

    public IntegerValue(long val) {
        this.val = val;
    }

    @Override
    public String javaString() {
        return Long.toString(this.val);
    }

    @Override
    public int javaInteger() {
        return (int)this.val;
    }

    @Override
    public float javaFloat() {
        return this.val;
    }

    @Override
    public boolean javaBoolean() {
        return this.val != 0L;
    }

    @Override
    public long javaLong() {
        return this.val;
    }

    @Override
    public boolean isInteger() {
        return true;
    }

    @Override
    public double javaDouble() {
        return this.val;
    }

    @Override
    public String toString() {
        return "integer<" + this.val + ">";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IntegerValue values = (IntegerValue)o;
        return this.val == values.val;
    }

    public int hashCode() {
        return (int)(this.val ^ this.val >>> 32);
    }
}

