/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.summary;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.neo4j.driver.Notification;
import org.neo4j.driver.Plan;
import org.neo4j.driver.ProfiledPlan;
import org.neo4j.driver.Record;
import org.neo4j.driver.Result;
import org.neo4j.driver.Statement;
import org.neo4j.driver.StatementType;
import org.neo4j.driver.UpdateStatistics;
import org.neo4j.driver.Value;
import org.neo4j.driver.exceptions.ClientException;
import org.neo4j.driver.internal.ParameterSupport;
import org.neo4j.driver.internal.SimpleRecord;
import org.neo4j.driver.internal.SimpleResult;
import org.neo4j.driver.internal.spi.StreamCollector;
import org.neo4j.driver.internal.summary.SummaryBuilder;

public class ResultBuilder
implements StreamCollector {
    private final SummaryBuilder summaryBuilder;
    private List<Record> body = new ArrayList<Record>();
    private Map<String, Integer> fieldLookup = null;

    public ResultBuilder(String statement, Map<String, Value> parameters) {
        Map<String, Value> unmodifiableParameters = parameters.isEmpty() ? ParameterSupport.NO_PARAMETERS : Collections.unmodifiableMap(parameters);
        this.summaryBuilder = new SummaryBuilder(new Statement(statement, unmodifiableParameters));
    }

    @Override
    public void fieldNames(String[] names) {
        if (this.fieldLookup == null) {
            if (names.length == 0) {
                this.fieldLookup = Collections.emptyMap();
            } else {
                HashMap<String, Integer> fieldLookup = new HashMap<String, Integer>();
                for (int i = 0; i < names.length; ++i) {
                    fieldLookup.put(names[i], i);
                }
                this.fieldLookup = fieldLookup;
            }
        } else {
            throw new ClientException("Received field names twice");
        }
    }

    @Override
    public void record(Value[] fields) {
        this.body.add(new SimpleRecord(this.fieldLookup, fields));
    }

    @Override
    public void statementType(StatementType type) {
        this.summaryBuilder.statementType(type);
    }

    @Override
    public void statementStatistics(UpdateStatistics statistics) {
        this.summaryBuilder.statementStatistics(statistics);
    }

    @Override
    public void plan(Plan plan) {
        this.summaryBuilder.plan(plan);
    }

    @Override
    public void profile(ProfiledPlan plan) {
        this.summaryBuilder.profile(plan);
    }

    @Override
    public void notifications(List<Notification> notifications) {
        this.summaryBuilder.notifications(notifications);
    }

    public Result build() {
        Set<String> fieldNames = this.fieldLookup == null ? Collections.emptySet() : this.fieldLookup.keySet();
        return new SimpleResult(fieldNames, this.body, this.summaryBuilder.build());
    }
}

