/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal;

import java.util.Collections;
import java.util.Map;
import org.neo4j.driver.Result;
import org.neo4j.driver.Statement;
import org.neo4j.driver.Transaction;
import org.neo4j.driver.Value;
import org.neo4j.driver.exceptions.ClientException;
import org.neo4j.driver.exceptions.Neo4jException;
import org.neo4j.driver.internal.ParameterSupport;
import org.neo4j.driver.internal.spi.Connection;
import org.neo4j.driver.internal.summary.ResultBuilder;

public class StandardTransaction
implements Transaction {
    private final Connection conn;
    private final Runnable cleanup;
    private State state = State.ACTIVE;

    public StandardTransaction(Connection conn, Runnable cleanup) {
        this.conn = conn;
        this.cleanup = cleanup;
        conn.run("BEGIN", Collections.emptyMap(), null);
        conn.discardAll();
    }

    @Override
    public void success() {
        if (this.state == State.ACTIVE) {
            this.state = State.MARKED_SUCCESS;
        }
    }

    @Override
    public void failure() {
        if (this.state == State.ACTIVE || this.state == State.MARKED_SUCCESS) {
            this.state = State.MARKED_FAILED;
        }
    }

    @Override
    public void close() {
        try {
            if (this.state == State.MARKED_SUCCESS) {
                this.conn.run("COMMIT", Collections.emptyMap(), null);
                this.conn.discardAll();
                this.conn.sync();
                this.state = State.SUCCEEDED;
            } else if (this.state == State.MARKED_FAILED || this.state == State.ACTIVE) {
                this.conn.run("ROLLBACK", Collections.emptyMap(), null);
                this.conn.discardAll();
                this.state = State.ROLLED_BACK;
            }
        }
        finally {
            this.cleanup.run();
        }
    }

    @Override
    public Result run(String statementText, Map<String, Value> parameters) {
        this.ensureNotFailed();
        try {
            ResultBuilder resultBuilder = new ResultBuilder(statementText, parameters);
            this.conn.run(statementText, parameters, resultBuilder);
            this.conn.pullAll(resultBuilder);
            this.conn.sync();
            return resultBuilder.build();
        }
        catch (Neo4jException e) {
            this.state = State.FAILED;
            throw e;
        }
    }

    @Override
    public Result run(String statementText) {
        return this.run(statementText, ParameterSupport.NO_PARAMETERS);
    }

    @Override
    public Result run(Statement statement) {
        return this.run(statement.text(), statement.parameters());
    }

    @Override
    public boolean isOpen() {
        return this.state == State.ACTIVE;
    }

    private void ensureNotFailed() {
        if (this.state == State.FAILED) {
            throw new ClientException("Cannot run more statements in this transaction, because previous statements in the transaction has failed and the transaction has been rolled back. Please start a new transaction to run another statement.");
        }
    }

    private static enum State {
        ACTIVE,
        MARKED_SUCCESS,
        MARKED_FAILED,
        FAILED,
        SUCCEEDED,
        ROLLED_BACK;

    }
}

