/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.neo4j.driver.Function;
import org.neo4j.driver.Identity;
import org.neo4j.driver.Node;
import org.neo4j.driver.Path;
import org.neo4j.driver.Relationship;
import org.neo4j.driver.Value;
import org.neo4j.driver.exceptions.ClientException;
import org.neo4j.driver.internal.value.BooleanValue;
import org.neo4j.driver.internal.value.FloatValue;
import org.neo4j.driver.internal.value.IdentityValue;
import org.neo4j.driver.internal.value.IntegerValue;
import org.neo4j.driver.internal.value.ListValue;
import org.neo4j.driver.internal.value.MapValue;
import org.neo4j.driver.internal.value.NodeValue;
import org.neo4j.driver.internal.value.PathValue;
import org.neo4j.driver.internal.value.RelationshipValue;
import org.neo4j.driver.internal.value.StringValue;

public class Values {
    public static final Value EmptyMap = Values.value(Collections.emptyMap());
    private static final Function<Value, Value> VALUE = new Function<Value, Value>(){

        @Override
        public Value apply(Value val) {
            return val;
        }
    };
    private static final Function<Value, String> STRING = new Function<Value, String>(){

        @Override
        public String apply(Value val) {
            return val.javaString();
        }
    };
    private static final Function<Value, Integer> INTEGER = new Function<Value, Integer>(){

        @Override
        public Integer apply(Value val) {
            return val.javaInteger();
        }
    };
    private static final Function<Value, Long> LONG = new Function<Value, Long>(){

        @Override
        public Long apply(Value val) {
            return val.javaLong();
        }
    };
    private static final Function<Value, Float> FLOAT = new Function<Value, Float>(){

        @Override
        public Float apply(Value val) {
            return Float.valueOf(val.javaFloat());
        }
    };
    private static final Function<Value, Double> DOUBLE = new Function<Value, Double>(){

        @Override
        public Double apply(Value val) {
            return val.javaDouble();
        }
    };
    private static final Function<Value, Boolean> BOOLEAN = new Function<Value, Boolean>(){

        @Override
        public Boolean apply(Value val) {
            return val.javaBoolean();
        }
    };

    public static Value value(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Value) {
            return (Value)value;
        }
        if (value instanceof Identity) {
            return new IdentityValue((Identity)value);
        }
        if (value instanceof Node) {
            return new NodeValue((Node)value);
        }
        if (value instanceof Relationship) {
            return new RelationshipValue((Relationship)value);
        }
        if (value instanceof Path) {
            return new PathValue((Path)value);
        }
        if (value instanceof Map) {
            return Values.value((Map)value);
        }
        if (value instanceof Collection) {
            return Values.value((List)value);
        }
        if (value instanceof Iterable) {
            return Values.value((Iterable)value);
        }
        if (value instanceof String) {
            return Values.value((String)value);
        }
        if (value instanceof Boolean) {
            return Values.value((Boolean)value);
        }
        if (value instanceof Byte) {
            return Values.value(((Byte)value).byteValue());
        }
        if (value instanceof Character) {
            return Values.value(((Character)value).charValue());
        }
        if (value instanceof Short) {
            return Values.value(((Short)value).shortValue());
        }
        if (value instanceof Integer) {
            return Values.value(((Integer)value).intValue());
        }
        if (value instanceof Long) {
            return Values.value((Long)value);
        }
        if (value instanceof Float) {
            return Values.value(((Float)value).floatValue());
        }
        if (value instanceof Double) {
            return Values.value((Double)value);
        }
        if (value instanceof String[]) {
            return Values.value((String[])value);
        }
        if (value instanceof boolean[]) {
            return Values.value((boolean[])value);
        }
        if (value instanceof char[]) {
            return Values.value((char[])value);
        }
        if (value instanceof short[]) {
            return Values.value((short[])value);
        }
        if (value instanceof int[]) {
            return Values.value((int[])value);
        }
        if (value instanceof long[]) {
            return Values.value((long[])value);
        }
        if (value instanceof float[]) {
            return Values.value((float[])value);
        }
        if (value instanceof double[]) {
            return Values.value((double[])value);
        }
        if (value instanceof Object[]) {
            return Values.value(Arrays.asList((Object[])value));
        }
        throw new ClientException("Unable to convert " + value.getClass().getName() + " to Neo4j Value.");
    }

    public static Value value(short[] val) {
        Value[] values = new Value[val.length];
        for (int i = 0; i < val.length; ++i) {
            values[i] = Values.value(val[i]);
        }
        return new ListValue(values);
    }

    public static Value value(int[] val) {
        Value[] values = new Value[val.length];
        for (int i = 0; i < val.length; ++i) {
            values[i] = Values.value(val[i]);
        }
        return new ListValue(values);
    }

    public static Value value(long[] val) {
        Value[] values = new Value[val.length];
        for (int i = 0; i < val.length; ++i) {
            values[i] = Values.value(val[i]);
        }
        return new ListValue(values);
    }

    public static Value value(boolean[] val) {
        Value[] values = new Value[val.length];
        for (int i = 0; i < val.length; ++i) {
            values[i] = Values.value(val[i]);
        }
        return new ListValue(values);
    }

    public static Value value(float[] val) {
        Value[] values = new Value[val.length];
        for (int i = 0; i < val.length; ++i) {
            values[i] = Values.value(val[i]);
        }
        return new ListValue(values);
    }

    public static Value value(double[] val) {
        Value[] values = new Value[val.length];
        for (int i = 0; i < val.length; ++i) {
            values[i] = Values.value(val[i]);
        }
        return new ListValue(values);
    }

    public static Value value(char[] val) {
        return new StringValue(new String(val));
    }

    public static Value value(String[] val) {
        Value[] values = new StringValue[val.length];
        for (int i = 0; i < val.length; ++i) {
            values[i] = new StringValue(val[i]);
        }
        return new ListValue(values);
    }

    public static Value value(Object[] val) {
        Value[] values = new Value[val.length];
        for (int i = 0; i < val.length; ++i) {
            values[i] = Values.value(val[i]);
        }
        return new ListValue(values);
    }

    public static Value value(List<Object> val) {
        Value[] values = new Value[val.size()];
        for (int i = 0; i < val.size(); ++i) {
            values[i] = Values.value(val.get(i));
        }
        return new ListValue(values);
    }

    public static Value value(Iterable<Object> val) {
        ArrayList<Value> values = new ArrayList<Value>();
        for (Object v : val) {
            values.add(Values.value(v));
        }
        return new ListValue(values.toArray(new Value[values.size()]));
    }

    public static Value value(long val) {
        return new IntegerValue(val);
    }

    public static Value value(double val) {
        return new FloatValue(val);
    }

    public static Value value(boolean val) {
        return new BooleanValue(val);
    }

    public static Value value(char val) {
        return new StringValue(Character.toString(val));
    }

    public static Value value(String val) {
        return new StringValue(val);
    }

    public static Value value(Map<String, Object> val) {
        HashMap<String, Value> asValues = new HashMap<String, Value>(val.size());
        for (Map.Entry<String, Object> entry : val.entrySet()) {
            asValues.put(entry.getKey(), Values.value(entry.getValue()));
        }
        return new MapValue(asValues);
    }

    public static Value[] values(Object ... vals) {
        Value[] values = new Value[vals.length];
        for (int i = 0; i < vals.length; ++i) {
            values[i] = Values.value(vals[i]);
        }
        return values;
    }

    public static Map<String, Value> parameters(Object ... keysAndValues) {
        if (keysAndValues.length % 2 != 0) {
            throw new ClientException("Parameters function requires an even number of arguments, alternating key and value. Arguments were: " + Arrays.toString(keysAndValues) + ".");
        }
        HashMap<String, Value> map = new HashMap<String, Value>(keysAndValues.length / 2);
        for (int i = 0; i < keysAndValues.length; i += 2) {
            map.put(keysAndValues[i].toString(), Values.value(keysAndValues[i + 1]));
        }
        return map;
    }

    public static Function<Value, Value> valueAsIs() {
        return VALUE;
    }

    public static Function<Value, String> valueToString() {
        return STRING;
    }

    public static Function<Value, Integer> valueToInt() {
        return INTEGER;
    }

    public static Function<Value, Long> valueToLong() {
        return LONG;
    }

    public static Function<Value, Float> valueToFloat() {
        return FLOAT;
    }

    public static Function<Value, Double> valueToDouble() {
        return DOUBLE;
    }

    public static Function<Value, Boolean> valueToBoolean() {
        return BOOLEAN;
    }

    public static <T> Function<Value, List<T>> valueToList(final Function<Value, T> innerMap) {
        return new Function<Value, List<T>>(){

            @Override
            public List<T> apply(Value value) {
                return value.javaList(innerMap);
            }
        };
    }
}

