/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.parser.v5.ast.factory;

import java.io.Serializable;
import java.util.List;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.RuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ErrorNode;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.neo4j.cypher.internal.ast.factory.ASTExceptionFactory;
import org.neo4j.cypher.internal.ast.factory.ConstraintType;
import org.neo4j.cypher.internal.ast.factory.HintIndexType;
import org.neo4j.cypher.internal.expressions.FunctionName;
import org.neo4j.cypher.internal.parser.AstRuleCtx;
import org.neo4j.cypher.internal.parser.ast.SyntaxChecker;
import org.neo4j.cypher.internal.parser.ast.util.Util$;
import org.neo4j.cypher.internal.parser.v5.Cypher5Parser;
import org.neo4j.cypher.internal.util.ASTNode;
import org.neo4j.cypher.internal.util.CypherExceptionFactory;
import org.neo4j.cypher.internal.util.InputPosition;
import org.neo4j.cypher.internal.util.InputPosition$;
import org.neo4j.cypher.internal.util.symbols.ClosedDynamicUnionType;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.immutable.ArraySeq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.IntRef;

@ScalaSignature(bytes="\u0006\u0005\tUh\u0001\u0002\u0014(\u0005aB\u0001B\u0012\u0001\u0003\u0002\u0003\u0006Ia\u0012\u0005\u0006\u001b\u0002!\tA\u0014\u0005\u0007%\u0002\u0001\u000b\u0015B*\t\u000b\u0011\u0004A\u0011I3\t\u000b)\u0004A\u0011I6\t\u000by\u0004A\u0011I@\t\u000f\u0005%\u0001\u0001\"\u0011\u0002\f!9\u0011\u0011\u0004\u0001\u0005B\u0005m\u0001bBA\u0010\u0001\u0011\u0005\u0013\u0011\u0005\u0005\b\u0003W\u0001A\u0011BA\u0017\u0011\u001d\ty\u0004\u0001C\u0005\u0003\u0003Bq!a\u0018\u0001\t\u0013\t\t\u0007C\u0005\u0002\u000e\u0002\t\n\u0011\"\u0003\u0002\u0010\"9\u0011\u0011\u0016\u0001\u0005\n\u0005-\u0006\"CA`\u0001E\u0005I\u0011BAa\u0011\u001d\t)\r\u0001C\u0005\u0003\u000fDq!!>\u0001\t\u0013\t9\u0010C\u0004\u0003\u0006\u0001!IAa\u0002\t\u000f\tE\u0001\u0001\"\u0003\u0003\u0014!9!Q\u0004\u0001\u0005\n\t}\u0001b\u0002B\u0015\u0001\u0011%!1\u0006\u0005\b\u0005k\u0001A\u0011\u0002B\u001c\u0011\u001d\u0011\t\u0005\u0001C\u0005\u0005\u0007BqA!\u0014\u0001\t\u0013\u0011y\u0005C\u0004\u0003Z\u0001!IAa\u0017\t\u000f\t\u0015\u0004\u0001\"\u0003\u0003h!9!\u0011\u000f\u0001\u0005\n\tM\u0004b\u0002B?\u0001\u0011%!q\u0010\u0005\b\u0005\u0013\u0003A\u0011\u0002BF\u0011\u001d\u0011)\n\u0001C\u0005\u0005/CqA!)\u0001\t\u0013\u0011\u0019\u000bC\u0004\u0003.\u0002!IAa,\t\u000f\te\u0006\u0001\"\u0003\u0003<\"9!Q\u0019\u0001\u0005\n\t\u001d\u0007b\u0002Bi\u0001\u0011%!1\u001b\u0005\b\u0005;\u0004A\u0011\u0002Bp\u0011\u001d\u0011I\u000f\u0001C\u0005\u0005W\u0014AcQ=qQ\u0016\u0014XgU=oi\u0006D8\t[3dW\u0016\u0014(B\u0001\u0015*\u0003\u001d1\u0017m\u0019;pefT!AK\u0016\u0002\u0007\u0005\u001cHO\u0003\u0002-[\u0005\u0011a/\u000e\u0006\u0003]=\na\u0001]1sg\u0016\u0014(B\u0001\u00192\u0003!Ig\u000e^3s]\u0006d'B\u0001\u001a4\u0003\u0019\u0019\u0017\u0010\u001d5fe*\u0011A'N\u0001\u0006]\u0016|GG\u001b\u0006\u0002m\u0005\u0019qN]4\u0004\u0001M\u0019\u0001!O!\u0011\u0005izT\"A\u001e\u000b\u0005qj\u0014\u0001\u00027b]\u001eT\u0011AP\u0001\u0005U\u00064\u0018-\u0003\u0002Aw\t1qJ\u00196fGR\u0004\"A\u0011#\u000e\u0003\rS!AK\u0017\n\u0005\u0015\u001b%!D*z]R\f\u0007p\u00115fG.,'/\u0001\tfq\u000e,\u0007\u000f^5p]\u001a\u000b7\r^8ssB\u0011\u0001jS\u0007\u0002\u0013*\u0011!jL\u0001\u0005kRLG.\u0003\u0002M\u0013\n12)\u001f9iKJ,\u0005pY3qi&|gNR1di>\u0014\u00180\u0001\u0004=S:LGO\u0010\u000b\u0003\u001fF\u0003\"\u0001\u0015\u0001\u000e\u0003\u001dBQA\u0012\u0002A\u0002\u001d\u000bqaX3se>\u00148\u000fE\u0002U=\u0006t!!V.\u000f\u0005YKV\"A,\u000b\u0005a;\u0014A\u0002\u001fs_>$h(C\u0001[\u0003\u0015\u00198-\u00197b\u0013\taV,A\u0004qC\u000e\\\u0017mZ3\u000b\u0003iK!a\u00181\u0003\u0007M+\u0017O\u0003\u0002];B\u0011AKY\u0005\u0003G\u0002\u0014\u0011\"\u0012=dKB$\u0018n\u001c8\u0002\r\u0015\u0014(o\u001c:t+\u00051\u0007c\u0001+_OB\u0011A\u000b[\u0005\u0003S\u0002\u0014\u0011\u0002\u00165s_^\f'\r\\3\u0002\u001bYL7/\u001b;UKJl\u0017N\\1m)\ta\u0007\u000f\u0005\u0002n]6\tQ,\u0003\u0002p;\n!QK\\5u\u0011\u0015\tX\u00011\u0001s\u0003\u0011qw\u000eZ3\u0011\u0005MdX\"\u0001;\u000b\u0005U4\u0018\u0001\u0002;sK\u0016T!a\u001e=\u0002\u000fI,h\u000e^5nK*\u0011\u0011P_\u0001\u0003mRR!a_\u001b\u0002\u000b\u0005tG\u000f\u001c:\n\u0005u$(\u0001\u0004+fe6Lg.\u00197O_\u0012,\u0017A\u0004<jg&$XI\u001d:pe:{G-\u001a\u000b\u0004Y\u0006\u0005\u0001BB9\u0007\u0001\u0004\t\u0019\u0001E\u0002t\u0003\u000bI1!a\u0002u\u0005%)%O]8s\u001d>$W-\u0001\bf]R,'/\u0012<fef\u0014V\u000f\\3\u0015\u00071\fi\u0001C\u0004\u0002\u0010\u001d\u0001\r!!\u0005\u0002\u0007\r$\b\u0010\u0005\u0003\u0002\u0014\u0005UQ\"\u0001<\n\u0007\u0005]aOA\tQCJ\u001cXM\u001d*vY\u0016\u001cuN\u001c;fqR\fQ\"\u001a=ji\u00163XM]=Sk2,Gc\u00017\u0002\u001e!9\u0011q\u0002\u0005A\u0002\u0005E\u0011!B2iK\u000e\\G\u0003BA\u0012\u0003S\u00012!\\A\u0013\u0013\r\t9#\u0018\u0002\b\u0005>|G.Z1o\u0011\u001d\ty!\u0003a\u0001\u0003#\tQ\"\u001b8qkR\u0004vn]5uS>tG\u0003BA\u0018\u0003k\u00012\u0001SA\u0019\u0013\r\t\u0019$\u0013\u0002\u000e\u0013:\u0004X\u000f\u001e)pg&$\u0018n\u001c8\t\u000f\u0005]\"\u00021\u0001\u0002:\u000511/_7c_2\u0004B!a\u0005\u0002<%\u0019\u0011Q\b<\u0003\u000bQ{7.\u001a8\u0002!\u0015\u0014(o\u001c:P]\u0012+\b\u000f\\5dCR,Gc\u00027\u0002D\u0005\u001d\u00131\f\u0005\b\u0003\u000bZ\u0001\u0019AA\u001d\u0003\u0015!xn[3o\u0011\u001d\tIe\u0003a\u0001\u0003\u0017\n1\u0002Z3tGJL\u0007\u000f^5p]B!\u0011QJA+\u001d\u0011\ty%!\u0015\u0011\u0005Yk\u0016bAA*;\u00061\u0001K]3eK\u001aLA!a\u0016\u0002Z\t11\u000b\u001e:j]\u001eT1!a\u0015^\u0011\u001d\tif\u0003a\u0001\u0003G\tq![:QCJ\fW.A\nfeJ|'o\u00148EkBd\u0017nY1uK\u000e#\b0\u0006\u0003\u0002d\u0005UDc\u00027\u0002f\u0005%\u00151\u0012\u0005\b\u0003\u001fa\u0001\u0019AA4!\u0019\tI'!\u001c\u0002r5\u0011\u00111\u000e\u0006\u0003\u0015vJA!a\u001c\u0002l\t!A*[:u!\u0011\t\u0019(!\u001e\r\u0001\u00119\u0011q\u000f\u0007C\u0002\u0005e$!\u0001+\u0012\t\u0005m\u0014\u0011\u0011\t\u0004[\u0006u\u0014bAA@;\n9aj\u001c;iS:<\u0007\u0003BAB\u0003\u000bk\u0011!L\u0005\u0004\u0003\u000fk#AC!tiJ+H.Z\"uq\"9\u0011\u0011\n\u0007A\u0002\u0005-\u0003\"CA/\u0019A\u0005\t\u0019AA\u0012\u0003u)'O]8s\u001f:$U\u000f\u001d7jG\u0006$Xm\u0011;yI\u0011,g-Y;mi\u0012\u001aT\u0003BAI\u0003O+\"!a%+\t\u0005\r\u0012QS\u0016\u0003\u0003/\u0003B!!'\u0002$6\u0011\u00111\u0014\u0006\u0005\u0003;\u000by*A\u0005v]\u000eDWmY6fI*\u0019\u0011\u0011U/\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002&\u0006m%!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u00129\u0011qO\u0007C\u0002\u0005e\u0014\u0001F3se>\u0014xJ\u001c#va2L7-\u0019;f%VdW-\u0006\u0003\u0002.\u0006]Fc\u00027\u00020\u0006m\u0016Q\u0018\u0005\b\u0003cs\u0001\u0019AAZ\u0003\u0019\u0001\u0018M]1ngB1\u0011\u0011NA7\u0003k\u0003B!a\u001d\u00028\u00129\u0011q\u000f\bC\u0002\u0005e\u0016\u0003BA>\u0003#Aq!!\u0013\u000f\u0001\u0004\tY\u0005C\u0005\u0002^9\u0001\n\u00111\u0001\u0002$\u0005qRM\u001d:pe>sG)\u001e9mS\u000e\fG/\u001a*vY\u0016$C-\u001a4bk2$HeM\u000b\u0005\u0003#\u000b\u0019\rB\u0004\u0002x=\u0011\r!!/\u0002=\u0015\u0014(o\u001c:P]\u0006c\u0017.Y:OC6,7i\u001c8uC&t\u0017N\\4E_R\u001cHc\u00017\u0002J\"9\u00111\u001a\tA\u0002\u00055\u0017\u0001D1mS\u0006\u001cXm\u001d(b[\u0016\u001c\bCBA5\u0003[\ny\r\u0005\u0003\u0002R\u0006=h\u0002BAj\u0003WtA!!6\u0002j:!\u0011q[At\u001d\u0011\tI.!:\u000f\t\u0005m\u00171\u001d\b\u0005\u0003;\f\tOD\u0002W\u0003?L\u0011AN\u0005\u0003iUJ!AM\u001a\n\u0005A\n\u0014B\u0001\u00180\u0013\taS&C\u0002\u0002n.\nQbQ=qQ\u0016\u0014X\u0007U1sg\u0016\u0014\u0018\u0002BAy\u0003g\u00141eU=nE>d\u0017nY!mS\u0006\u001ch*Y7f\u001fJ\u0004\u0016M]1nKR,'oQ8oi\u0016DHOC\u0002\u0002n.\nQe\u00195fG.\u001cVOY9vKJL\u0018J\u001c+sC:\u001c\u0018m\u0019;j_:\u001c\b+\u0019:b[\u0016$XM]:\u0015\u00071\fI\u0010C\u0004\u0002\u0010E\u0001\r!a?\u0011\t\u0005u(\u0011\u0001\b\u0005\u0003\u007f\fY/D\u0001,\u0013\u0011\u0011\u0019!a=\u0003OM+(-];fefLe\u000e\u0016:b]N\f7\r^5p]N\u0004\u0016M]1nKR,'o]\"p]R,\u0007\u0010^\u0001\u0011G\",7m[\"sK\u0006$X-\u00117jCN$2\u0001\u001cB\u0005\u0011\u001d\tyA\u0005a\u0001\u0005\u0017\u0001B!!@\u0003\u000e%!!qBAz\u0005I\u0019%/Z1uK\u0006c\u0017.Y:D_:$X\r\u001f;\u0002\u001f\rDWmY6BYR,'/\u00117jCN$2\u0001\u001cB\u000b\u0011\u001d\tya\u0005a\u0001\u0005/\u0001B!!@\u0003\u001a%!!1DAz\u0005E\tE\u000e^3s\u00032L\u0017m]\"p]R,\u0007\u0010^\u0001\u0010G\",7m[\"sK\u0006$X-V:feR\u0019AN!\t\t\u000f\u0005=A\u00031\u0001\u0003$A!\u0011Q B\u0013\u0013\u0011\u00119#a=\u0003#\r\u0013X-\u0019;f+N,'oQ8oi\u0016DH/\u0001\bdQ\u0016\u001c7.\u00117uKJ,6/\u001a:\u0015\u00071\u0014i\u0003C\u0004\u0002\u0010U\u0001\rAa\f\u0011\t\u0005u(\u0011G\u0005\u0005\u0005g\t\u0019P\u0001\tBYR,'/V:fe\u000e{g\u000e^3yi\u0006\t2\r[3dW\u0006cG\u000e\u0015:jm&dWmZ3\u0015\u00071\u0014I\u0004C\u0004\u0002\u0010Y\u0001\rAa\u000f\u0011\t\u0005u(QH\u0005\u0005\u0005\u007f\t\u0019PA\nBY2\u0004&/\u001b<jY\u0016<WmQ8oi\u0016DH/A\u0007dQ\u0016\u001c7n\u00127pEB\u000b'\u000f\u001e\u000b\u0004Y\n\u0015\u0003bBA\b/\u0001\u0007!q\t\t\u0005\u0003{\u0014I%\u0003\u0003\u0003L\u0005M(aD$m_\n\u0004\u0016M\u001d;D_:$X\r\u001f;\u0002+\rDWmY6De\u0016\fG/Z\"p]N$(/Y5oiR\u0019AN!\u0015\t\u000f\u0005=\u0001\u00041\u0001\u0003TA!\u0011Q B+\u0013\u0011\u00119&a=\u0003/\r\u0013X-\u0019;f\u0007>t7\u000f\u001e:bS:$8i\u001c8uKb$\u0018!G2iK\u000e\\WI\\2m_N,G\r\u0015:pa\u0016\u0014H/\u001f'jgR$2\u0001\u001cB/\u0011\u001d\ty!\u0007a\u0001\u0005?\u0002B!!@\u0003b%!!1MAz\u0005m)en\u00197pg\u0016$\u0007K]8qKJ$\u0018\u0010T5ti\u000e{g\u000e^3yi\u0006\u00192\r[3dW\u0012\u0013x\u000e]\"p]N$(/Y5oiR\u0019AN!\u001b\t\u000f\u0005=!\u00041\u0001\u0003lA!\u0011Q B7\u0013\u0011\u0011y'a=\u0003+\u0011\u0013x\u000e]\"p]N$(/Y5oi\u000e{g\u000e^3yi\u0006\u00192\r[3dW\u000e\u0013X-\u0019;f\t\u0006$\u0018MY1tKR\u0019AN!\u001e\t\u000f\u0005=1\u00041\u0001\u0003xA!\u0011Q B=\u0013\u0011\u0011Y(a=\u0003+\r\u0013X-\u0019;f\t\u0006$\u0018MY1tK\u000e{g\u000e^3yi\u0006\u00112\r[3dW\u0006cG/\u001a:ECR\f'-Y:f)\ra'\u0011\u0011\u0005\b\u0003\u001fa\u0002\u0019\u0001BB!\u0011\tiP!\"\n\t\t\u001d\u00151\u001f\u0002\u0015\u00032$XM\u001d#bi\u0006\u0014\u0017m]3D_:$X\r\u001f;\u00025\rDWmY6BYR,'\u000fR1uC\n\f7/\u001a+pa>dwnZ=\u0015\u00071\u0014i\tC\u0004\u0002\u0010u\u0001\rAa$\u0011\t\u0005u(\u0011S\u0005\u0005\u0005'\u000b\u0019P\u0001\u000fBYR,'\u000fR1uC\n\f7/\u001a+pa>dwnZ=D_:$X\r\u001f;\u0002G\rDWmY6QKJLw\u000eZ5d\u0007>lW.\u001b;Rk\u0016\u0014\u0018\u0010S5oi\u001a\u000b\u0017\u000e\\;sKR\u0019AN!'\t\u000f\u0005=a\u00041\u0001\u0003\u001cB!\u0011Q BO\u0013\u0011\u0011y*a=\u0003KA+'/[8eS\u000e\u001cu.\\7jiF+XM]=IS:$h)Y5mkJ,7i\u001c8uKb$\u0018AE2iK\u000e\\7I]3bi\u0016\u001cu.\\7b]\u0012$2\u0001\u001cBS\u0011\u001d\tya\ba\u0001\u0005O\u0003B!!@\u0003*&!!1VAz\u0005Q\u0019%/Z1uK\u000e{W.\\1oI\u000e{g\u000e^3yi\u000612\r[3dW\u000e\u0013X-\u0019;f\u0019>|7.\u001e9J]\u0012,\u0007\u0010F\u0002m\u0005cCq!a\u0004!\u0001\u0004\u0011\u0019\f\u0005\u0003\u0002~\nU\u0016\u0002\u0002B\\\u0003g\u0014\u0001d\u0011:fCR,Gj\\8lkBLe\u000eZ3y\u0007>tG/\u001a=u\u0003I\u0019\u0007.Z2l\u0013:\u001cXM\u001d;QCR$XM\u001d8\u0015\u00071\u0014i\fC\u0004\u0002\u0010\u0005\u0002\rAa0\u0011\t\u0005u(\u0011Y\u0005\u0005\u0005\u0007\f\u0019P\u0001\u000bJ]N,'\u000f\u001e)biR,'O\\\"p]R,\u0007\u0010^\u0001\u001cG\",7m[%og\u0016\u0014H\u000fT1cK2\u001cuN\u001c6v]\u000e$\u0018n\u001c8\u0015\u00071\u0014I\rC\u0004\u0002\u0010\t\u0002\rAa3\u0011\t\u0005u(QZ\u0005\u0005\u0005\u001f\f\u0019P\u0001\u0011J]N,'\u000f\u001e(pI\u0016d\u0015MY3m\u000bb\u0004(/Z:tS>t7i\u001c8uKb$\u0018aF2iK\u000e\\g)\u001e8di&|g.\u00138w_\u000e\fG/[8o)\ra'Q\u001b\u0005\b\u0003\u001f\u0019\u0003\u0019\u0001Bl!\u0011\tiP!7\n\t\tm\u00171\u001f\u0002\u001a\rVt7\r^5p]&sgo\\2bi&|gnQ8oi\u0016DH/A\u0007dQ\u0016\u001c7\u000eV=qKB\u000b'\u000f\u001e\u000b\u0004Y\n\u0005\bbBA\bI\u0001\u0007!1\u001d\t\u0005\u0003{\u0014)/\u0003\u0003\u0003h\u0006M(a\u0004+za\u0016\u0004\u0016M\u001d;D_:$X\r\u001f;\u0002\u0013\rDWmY6IS:$Hc\u00017\u0003n\"9\u0011qB\u0013A\u0002\t=\b\u0003BA\u007f\u0005cLAAa=\u0002t\nY\u0001*\u001b8u\u0007>tG/\u001a=u\u0001")
public final class Cypher5SyntaxChecker
implements SyntaxChecker {
    private final CypherExceptionFactory exceptionFactory;
    private Seq<Exception> _errors;

    public Seq<Throwable> errors() {
        return this._errors;
    }

    public void visitTerminal(TerminalNode node) {
    }

    public void visitErrorNode(ErrorNode node) {
    }

    public void enterEveryRule(ParserRuleContext ctx) {
    }

    public void exitEveryRule(ParserRuleContext ctx) {
        int n = ctx.getRuleIndex();
        switch (n) {
            case 2: {
                this.checkPeriodicCommitQueryHintFailure((Cypher5Parser.PeriodicCommitQueryHintFailureContext)Util$.MODULE$.cast((Object)ctx));
                return;
            }
            case 41: {
                this.checkSubqueryInTransactionsParameters((Cypher5Parser.SubqueryInTransactionsParametersContext)Util$.MODULE$.cast((Object)ctx));
                return;
            }
            case 136: {
                this.checkCreateCommand((Cypher5Parser.CreateCommandContext)Util$.MODULE$.cast((Object)ctx));
                return;
            }
            case 178: {
                this.checkCreateConstraint((Cypher5Parser.CreateConstraintContext)Util$.MODULE$.cast((Object)ctx));
                return;
            }
            case 192: {
                this.checkEnclosedPropertyList((Cypher5Parser.EnclosedPropertyListContext)Util$.MODULE$.cast((Object)ctx));
                return;
            }
            case 180: {
                this.checkDropConstraint((Cypher5Parser.DropConstraintContext)Util$.MODULE$.cast((Object)ctx));
                return;
            }
            case 187: {
                this.checkCreateLookupIndex((Cypher5Parser.CreateLookupIndexContext)Util$.MODULE$.cast((Object)ctx));
                return;
            }
            case 206: {
                this.checkCreateUser((Cypher5Parser.CreateUserContext)Util$.MODULE$.cast((Object)ctx));
                return;
            }
            case 210: {
                this.checkAlterUser((Cypher5Parser.AlterUserContext)Util$.MODULE$.cast((Object)ctx));
                return;
            }
            case 236: {
                this.checkAllPrivilege((Cypher5Parser.AllPrivilegeContext)Util$.MODULE$.cast((Object)ctx));
                return;
            }
            case 276: {
                this.checkCreateDatabase((Cypher5Parser.CreateDatabaseContext)Util$.MODULE$.cast((Object)ctx));
                return;
            }
            case 282: {
                this.checkAlterDatabase((Cypher5Parser.AlterDatabaseContext)Util$.MODULE$.cast((Object)ctx));
                return;
            }
            case 284: {
                this.checkAlterDatabaseTopology((Cypher5Parser.AlterDatabaseTopologyContext)Util$.MODULE$.cast((Object)ctx));
                return;
            }
            case 296: {
                this.checkCreateAlias((Cypher5Parser.CreateAliasContext)Util$.MODULE$.cast((Object)ctx));
                return;
            }
            case 298: {
                this.checkAlterAlias((Cypher5Parser.AlterAliasContext)Util$.MODULE$.cast((Object)ctx));
                return;
            }
            case 311: {
                this.checkGlobPart((Cypher5Parser.GlobPartContext)Util$.MODULE$.cast((Object)ctx));
                return;
            }
            case 48: {
                this.checkInsertPattern((Cypher5Parser.InsertPatternContext)Util$.MODULE$.cast((Object)ctx));
                return;
            }
            case 81: {
                this.checkInsertLabelConjunction((Cypher5Parser.InsertNodeLabelExpressionContext)Util$.MODULE$.cast((Object)ctx));
                return;
            }
            case 129: {
                this.checkFunctionInvocation((Cypher5Parser.FunctionInvocationContext)Util$.MODULE$.cast((Object)ctx));
                return;
            }
            case 172: {
                this.checkTypePart((Cypher5Parser.TypePartContext)Util$.MODULE$.cast((Object)ctx));
                return;
            }
            case 30: {
                this.checkHint((Cypher5Parser.HintContext)Util$.MODULE$.cast((Object)ctx));
                return;
            }
        }
    }

    public boolean check(ParserRuleContext ctx) {
        this.exitEveryRule(ctx);
        return this._errors.isEmpty();
    }

    private InputPosition inputPosition(Token symbol) {
        return InputPosition$.MODULE$.apply(symbol.getStartIndex(), symbol.getLine(), symbol.getCharPositionInLine() + 1);
    }

    private void errorOnDuplicate(Token token, String description, boolean isParam) {
        if (isParam) {
            this._errors = (Seq)this._errors.$colon$plus((Object)this.exceptionFactory.syntaxException("Duplicated " + description + " parameters", this.inputPosition(token)));
            return;
        }
        this._errors = (Seq)this._errors.$colon$plus((Object)this.exceptionFactory.syntaxException("Duplicate " + description + " clause", this.inputPosition(token)));
    }

    private <T extends AstRuleCtx> void errorOnDuplicateCtx(List<T> ctx, String description, boolean isParam) {
        if (ctx.size() > 1) {
            this.errorOnDuplicate(Util$.MODULE$.nodeChild((AstRuleCtx)ctx.get(1), 0).getSymbol(), description, isParam);
            return;
        }
    }

    private <T extends AstRuleCtx> boolean errorOnDuplicateCtx$default$3() {
        return false;
    }

    private <T extends ParserRuleContext> void errorOnDuplicateRule(List<T> params, String description, boolean isParam) {
        if (params.size() > 1) {
            this.errorOnDuplicate(((ParserRuleContext)params.get((int)1)).start, description, isParam);
            return;
        }
    }

    private <T extends ParserRuleContext> boolean errorOnDuplicateRule$default$3() {
        return false;
    }

    private void errorOnAliasNameContainingDots(List<Cypher5Parser.SymbolicAliasNameOrParameterContext> aliasesNames) {
        if (aliasesNames.size() > 0) {
            Cypher5Parser.SymbolicAliasNameOrParameterContext aliasName = aliasesNames.get(0);
            if (aliasName.symbolicAliasName() != null && aliasName.symbolicAliasName().symbolicNameString().size() > 2) {
                Token start = ((ParserRuleContext)aliasName.symbolicAliasName().symbolicNameString().get(0)).getStart();
                this._errors = (Seq)this._errors.$colon$plus((Object)this.exceptionFactory.syntaxException("'.' is not a valid character in the remote alias name '" + aliasName.getText() + "'. Remote alias names using '.' must be quoted with backticks e.g. `remote.alias`.", this.inputPosition(start)));
                return;
            }
            return;
        }
    }

    private void checkSubqueryInTransactionsParameters(Cypher5Parser.SubqueryInTransactionsParametersContext ctx) {
        this.errorOnDuplicateRule(ctx.subqueryInTransactionsBatchParameters(), "OF ROWS", true);
        this.errorOnDuplicateRule(ctx.subqueryInTransactionsErrorParameters(), "ON ERROR", true);
        this.errorOnDuplicateRule(ctx.subqueryInTransactionsReportParameters(), "REPORT STATUS", true);
    }

    private void checkCreateAlias(Cypher5Parser.CreateAliasContext ctx) {
        if (ctx.stringOrParameter() != null) {
            this.errorOnAliasNameContainingDots(ctx.symbolicAliasNameOrParameter());
            return;
        }
    }

    private void checkAlterAlias(Cypher5Parser.AlterAliasContext ctx) {
        List aliasTargets = ctx.alterAliasTarget();
        boolean hasUrl = !aliasTargets.isEmpty() && ((Cypher5Parser.AlterAliasTargetContext)aliasTargets.get(0)).AT() != null;
        List usernames = ctx.alterAliasUser();
        List passwords = ctx.alterAliasPassword();
        List driverSettings = ctx.alterAliasDriver();
        if (hasUrl || !usernames.isEmpty() || !passwords.isEmpty() || !driverSettings.isEmpty()) {
            this.errorOnAliasNameContainingDots(List.of(ctx.symbolicAliasNameOrParameter()));
        }
        this.errorOnDuplicateCtx(driverSettings, "DRIVER", this.errorOnDuplicateCtx$default$3());
        this.errorOnDuplicateCtx(usernames, "USER", this.errorOnDuplicateCtx$default$3());
        this.errorOnDuplicateCtx(passwords, "PASSWORD", this.errorOnDuplicateCtx$default$3());
        this.errorOnDuplicateCtx(ctx.alterAliasProperties(), "PROPERTIES", this.errorOnDuplicateCtx$default$3());
        this.errorOnDuplicateCtx(aliasTargets, "TARGET", this.errorOnDuplicateCtx$default$3());
    }

    private void checkCreateUser(Cypher5Parser.CreateUserContext ctx) {
        this.errorOnDuplicateRule(ctx.userStatus(), "SET STATUS {SUSPENDED|ACTIVE}", this.errorOnDuplicateRule$default$3());
        this.errorOnDuplicateRule(ctx.homeDatabase(), "SET HOME DATABASE", this.errorOnDuplicateRule$default$3());
    }

    private void checkAlterUser(Cypher5Parser.AlterUserContext ctx) {
        this.errorOnDuplicateRule(ctx.userStatus(), "SET STATUS {SUSPENDED|ACTIVE}", this.errorOnDuplicateRule$default$3());
        this.errorOnDuplicateRule(ctx.homeDatabase(), "SET HOME DATABASE", this.errorOnDuplicateRule$default$3());
    }

    private void checkAllPrivilege(Cypher5Parser.AllPrivilegeContext ctx) {
        Cypher5Parser.AllPrivilegeTypeContext privilegeType = ctx.allPrivilegeType();
        Cypher5Parser.AllPrivilegeTargetContext privilegeTarget = ctx.allPrivilegeTarget();
        if (privilegeType != null) {
            Tuple2 tuple2;
            Some privilege = privilegeType.GRAPH() != null ? new Some((Object)"GRAPH") : (privilegeType.DBMS() != null ? new Some((Object)"DBMS") : (privilegeType.DATABASE() != null ? new Some((Object)"DATABASE") : None$.MODULE$));
            Cypher5Parser.AllPrivilegeTargetContext allPrivilegeTargetContext = privilegeTarget;
            if (allPrivilegeTargetContext instanceof Cypher5Parser.DefaultTargetContext) {
                Some some;
                String string;
                Cypher5Parser.DefaultTargetContext defaultTargetContext = (Cypher5Parser.DefaultTargetContext)allPrivilegeTargetContext;
                Some some2 = privilege;
                tuple2 = some2 instanceof Some && "DBMS".equals(string = (String)(some = some2).value()) ? (defaultTargetContext.HOME() != null ? new Tuple2((Object)"HOME", (Object)defaultTargetContext.HOME().getSymbol()) : new Tuple2((Object)"DEFAULT", (Object)defaultTargetContext.DEFAULT().getSymbol())) : (defaultTargetContext.GRAPH() != null ? new Tuple2((Object)"GRAPH", (Object)defaultTargetContext.GRAPH().getSymbol()) : new Tuple2((Object)"DATABASE", (Object)defaultTargetContext.DATABASE().getSymbol()));
            } else if (allPrivilegeTargetContext instanceof Cypher5Parser.DatabaseVariableTargetContext) {
                Cypher5Parser.DatabaseVariableTargetContext databaseVariableTargetContext = (Cypher5Parser.DatabaseVariableTargetContext)allPrivilegeTargetContext;
                tuple2 = databaseVariableTargetContext.DATABASE() != null ? new Tuple2((Object)"DATABASE", (Object)databaseVariableTargetContext.DATABASE().getSymbol()) : new Tuple2((Object)"DATABASES", (Object)databaseVariableTargetContext.DATABASES().getSymbol());
            } else if (allPrivilegeTargetContext instanceof Cypher5Parser.GraphVariableTargetContext) {
                Cypher5Parser.GraphVariableTargetContext graphVariableTargetContext = (Cypher5Parser.GraphVariableTargetContext)allPrivilegeTargetContext;
                tuple2 = graphVariableTargetContext.GRAPH() != null ? new Tuple2((Object)"GRAPH", (Object)graphVariableTargetContext.GRAPH().getSymbol()) : new Tuple2((Object)"GRAPHS", (Object)graphVariableTargetContext.GRAPHS().getSymbol());
            } else if (allPrivilegeTargetContext instanceof Cypher5Parser.DBMSTargetContext) {
                Cypher5Parser.DBMSTargetContext dBMSTargetContext = (Cypher5Parser.DBMSTargetContext)allPrivilegeTargetContext;
                tuple2 = new Tuple2((Object)"DBMS", (Object)dBMSTargetContext.DBMS().getSymbol());
            } else {
                throw new IllegalStateException("Unexpected privilege all command");
            }
            Tuple2 target = tuple2;
            Tuple2 tuple22 = new Tuple2((Object)privilege, (Object)target);
            if (tuple22 != null) {
                Option option = (Option)tuple22._1();
                Tuple2 tuple23 = (Tuple2)tuple22._2();
                if (option instanceof Some) {
                    Some some = (Some)option;
                    String privilege2 = (String)some.value();
                    if (tuple23 != null) {
                        String target2 = (String)tuple23._1();
                        Token symbol = (Token)tuple23._2();
                        if (!target2.startsWith(privilege2)) {
                            this._errors = (Seq)this._errors.$colon$plus((Object)this.exceptionFactory.syntaxException("Invalid input '" + target2 + "': expected \"" + privilege2 + "\"", this.inputPosition(symbol)));
                            return;
                        }
                        return;
                    }
                }
            }
            return;
        }
    }

    private void checkGlobPart(Cypher5Parser.GlobPartContext ctx) {
        if (ctx.DOT() == null) {
            Cypher5Parser.GlobContext globContext;
            Cypher5Parser.GlobRecursiveContext globRecursiveContext;
            RuleContext ruleContext = ctx.parent.parent;
            if (ruleContext instanceof Cypher5Parser.GlobRecursiveContext && (globRecursiveContext = (Cypher5Parser.GlobRecursiveContext)ruleContext).globPart().escapedSymbolicNameString() != null) {
                this.addError$1(ctx);
            } else if (ruleContext instanceof Cypher5Parser.GlobContext && (globContext = (Cypher5Parser.GlobContext)ruleContext).escapedSymbolicNameString() != null) {
                this.addError$1(ctx);
            }
            return;
        }
    }

    private void checkCreateConstraint(Cypher5Parser.CreateConstraintContext ctx) {
        Cypher5Parser.ConstraintTypeContext constraintTypeContext = ctx.constraintType();
        if (constraintTypeContext instanceof Cypher5Parser.ConstraintIsUniqueContext) {
            Cypher5Parser.ConstraintIsUniqueContext constraintIsUniqueContext = (Cypher5Parser.ConstraintIsUniqueContext)constraintTypeContext;
            if (ctx.commandNodePattern() != null && (constraintIsUniqueContext.RELATIONSHIP() != null || constraintIsUniqueContext.REL() != null)) {
                this._errors = (Seq)this._errors.$colon$plus((Object)this.exceptionFactory.syntaxException("'" + ConstraintType.REL_UNIQUE.description() + "' does not allow node patterns", this.inputPosition(ctx.commandNodePattern().getStart())));
            }
            if (ctx.commandRelPattern() != null && constraintIsUniqueContext.NODE() != null) {
                this._errors = (Seq)this._errors.$colon$plus((Object)this.exceptionFactory.syntaxException("'" + ConstraintType.NODE_UNIQUE.description() + "' does not allow relationship patterns", this.inputPosition(ctx.commandRelPattern().getStart())));
                return;
            }
            return;
        }
        if (constraintTypeContext instanceof Cypher5Parser.ConstraintKeyContext) {
            Cypher5Parser.ConstraintKeyContext constraintKeyContext = (Cypher5Parser.ConstraintKeyContext)constraintTypeContext;
            if (ctx.commandNodePattern() != null && (constraintKeyContext.RELATIONSHIP() != null || constraintKeyContext.REL() != null)) {
                this._errors = (Seq)this._errors.$colon$plus((Object)this.exceptionFactory.syntaxException("'" + ConstraintType.REL_KEY.description() + "' does not allow node patterns", this.inputPosition(ctx.commandNodePattern().getStart())));
            }
            if (ctx.commandRelPattern() != null && constraintKeyContext.NODE() != null) {
                this._errors = (Seq)this._errors.$colon$plus((Object)this.exceptionFactory.syntaxException("'" + ConstraintType.NODE_KEY.description() + "' does not allow relationship patterns", this.inputPosition(ctx.commandRelPattern().getStart())));
                return;
            }
            return;
        }
        if (constraintTypeContext instanceof Cypher5Parser.ConstraintExistsContext ? true : (constraintTypeContext instanceof Cypher5Parser.ConstraintTypedContext ? true : constraintTypeContext instanceof Cypher5Parser.ConstraintIsNotNullContext)) {
            return;
        }
        this._errors = (Seq)this._errors.$colon$plus((Object)this.exceptionFactory.syntaxException("Constraint type is not recognized", this.inputPosition(ctx.constraintType().getStart())));
    }

    private void checkEnclosedPropertyList(Cypher5Parser.EnclosedPropertyListContext ctx) {
        if (ctx.property().size() > 1 && ctx.getParent() != null) {
            Cypher5Parser.DropConstraintContext dropConstraintContext;
            Token secondProperty = ctx.property((int)1).start;
            ParserRuleContext parserRuleContext = ctx.getParent().getParent();
            if (parserRuleContext instanceof Cypher5Parser.ConstraintExistsContext) {
                this._errors = (Seq)this._errors.$colon$plus((Object)this.exceptionFactory.syntaxException("Constraint type 'EXISTS' does not allow multiple properties", this.inputPosition(secondProperty)));
                return;
            }
            if (parserRuleContext instanceof Cypher5Parser.ConstraintTypedContext) {
                this._errors = (Seq)this._errors.$colon$plus((Object)this.exceptionFactory.syntaxException("Constraint type 'IS TYPED' does not allow multiple properties", this.inputPosition(secondProperty)));
                return;
            }
            if (parserRuleContext instanceof Cypher5Parser.ConstraintIsNotNullContext) {
                this._errors = (Seq)this._errors.$colon$plus((Object)this.exceptionFactory.syntaxException("Constraint type 'IS NOT NULL' does not allow multiple properties", this.inputPosition(secondProperty)));
                return;
            }
            if (parserRuleContext instanceof Cypher5Parser.DropConstraintContext && (dropConstraintContext = (Cypher5Parser.DropConstraintContext)parserRuleContext).EXISTS() != null) {
                this._errors = (Seq)this._errors.$colon$plus((Object)this.exceptionFactory.syntaxException("Constraint type 'EXISTS' does not allow multiple properties", this.inputPosition(secondProperty)));
                return;
            }
            return;
        }
    }

    private void checkDropConstraint(Cypher5Parser.DropConstraintContext ctx) {
        Cypher5Parser.CommandRelPatternContext relPattern = ctx.commandRelPattern();
        if (relPattern != null) {
            String errorMessageEnd = "does not allow relationship patterns";
            if (ctx.KEY() != null) {
                this._errors = (Seq)this._errors.$colon$plus((Object)this.exceptionFactory.syntaxException("'" + ConstraintType.NODE_KEY.description() + "' " + errorMessageEnd, this.inputPosition(relPattern.getStart())));
            } else if (ctx.UNIQUE() != null) {
                this._errors = (Seq)this._errors.$colon$plus((Object)this.exceptionFactory.syntaxException("'" + ConstraintType.NODE_UNIQUE.description() + "' " + errorMessageEnd, this.inputPosition(relPattern.getStart())));
            }
        }
        if (ctx.NULL() != null) {
            this._errors = (Seq)this._errors.$colon$plus((Object)this.exceptionFactory.syntaxException("Unsupported drop constraint command: Please delete the constraint by name instead", this.inputPosition(ctx.start)));
            return;
        }
    }

    private void checkCreateDatabase(Cypher5Parser.CreateDatabaseContext ctx) {
        this.errorOnDuplicateRule(ctx.primaryTopology(), "PRIMARY", this.errorOnDuplicateRule$default$3());
        this.errorOnDuplicateRule(ctx.secondaryTopology(), "SECONDARY", this.errorOnDuplicateRule$default$3());
    }

    private void checkAlterDatabase(Cypher5Parser.AlterDatabaseContext ctx) {
        if (!ctx.REMOVE().isEmpty()) {
            ArraySeq keyNames = Util$.MODULE$.astSeq(ctx.symbolicNameString(), Util$.MODULE$.astSeq$default$2(), ClassTag$.MODULE$.apply(String.class));
            Set keySet = (Set)Set$.MODULE$.empty();
            IntRef i = IntRef.create((int)0);
            keyNames.foreach((Function1 & Serializable)k -> {
                Cypher5SyntaxChecker.$anonfun$checkAlterDatabase$1(this, keySet, ctx, i, k);
                return BoxedUnit.UNIT;
            });
        }
        if (!ctx.alterDatabaseOption().isEmpty()) {
            ArraySeq optionCtxs = Util$.MODULE$.astSeq(ctx.alterDatabaseOption(), Util$.MODULE$.astSeq$default$2(), ClassTag$.MODULE$.apply(Map.class));
            ArraySeq keyNames = (ArraySeq)optionCtxs.flatMap((Function1 & Serializable)m -> {
                if (m != null) {
                    return m.keys();
                }
                return (Iterable)package$.MODULE$.Seq().empty();
            });
            Set keySet = (Set)Set$.MODULE$.empty();
            IntRef i = IntRef.create((int)0);
            keyNames.foreach((Function1 & Serializable)k -> {
                Cypher5SyntaxChecker.$anonfun$checkAlterDatabase$3(this, keySet, ctx, i, k);
                return BoxedUnit.UNIT;
            });
        }
        this.errorOnDuplicateCtx(ctx.alterDatabaseAccess(), "ACCESS", this.errorOnDuplicateCtx$default$3());
        List topology = ctx.alterDatabaseTopology();
        this.errorOnDuplicateCtx(topology, "TOPOLOGY", this.errorOnDuplicateCtx$default$3());
    }

    private void checkAlterDatabaseTopology(Cypher5Parser.AlterDatabaseTopologyContext ctx) {
        this.errorOnDuplicateRule(ctx.primaryTopology(), "PRIMARY", this.errorOnDuplicateRule$default$3());
        this.errorOnDuplicateRule(ctx.secondaryTopology(), "SECONDARY", this.errorOnDuplicateRule$default$3());
    }

    private void checkPeriodicCommitQueryHintFailure(Cypher5Parser.PeriodicCommitQueryHintFailureContext ctx) {
        Token periodic = ctx.PERIODIC().getSymbol();
        this._errors = (Seq)this._errors.$colon$plus((Object)this.exceptionFactory.syntaxException("The PERIODIC COMMIT query hint is no longer supported. Please use CALL { ... } IN TRANSACTIONS instead.", this.inputPosition(periodic)));
    }

    private void checkCreateCommand(Cypher5Parser.CreateCommandContext ctx) {
        Cypher5Parser.CreateIndexContext createIndex = ctx.createIndex();
        TerminalNode replace = ctx.REPLACE();
        if (createIndex != null && replace != null) {
            if (createIndex.oldCreateIndex() != null) {
                this._errors = (Seq)this._errors.$colon$plus((Object)this.exceptionFactory.syntaxException("'REPLACE' is not allowed for this index syntax", this.inputPosition(replace.getSymbol())));
                return;
            }
            return;
        }
    }

    private void checkCreateLookupIndex(Cypher5Parser.CreateLookupIndexContext ctx) {
        Cypher5Parser.SymbolicNameStringContext functionName = ctx.symbolicNameString();
        Cypher5Parser.LookupIndexRelPatternContext relPattern = ctx.lookupIndexRelPattern();
        String string = functionName.getText().toUpperCase();
        String string2 = "EACH";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            if (relPattern != null && relPattern.EACH() == null) {
                this._errors = (Seq)this._errors.$colon$plus((Object)this.exceptionFactory.syntaxException("Missing function name for the LOOKUP INDEX", this.inputPosition(ctx.LPAREN().getSymbol())));
                return;
            }
        }
    }

    private void checkInsertPattern(Cypher5Parser.InsertPatternContext ctx) {
        if (ctx.EQ() != null) {
            this._errors = (Seq)this._errors.$colon$plus((Object)this.exceptionFactory.syntaxException("Named patterns are not allowed in `INSERT`. Use `CREATE` instead or remove the name.", Util$.MODULE$.pos((ParserRuleContext)Util$.MODULE$.ctxChild((AstRuleCtx)ctx, 0))));
            return;
        }
    }

    private void checkInsertLabelConjunction(Cypher5Parser.InsertNodeLabelExpressionContext ctx) {
        boolean firstIsColon;
        List colons = ctx.COLON();
        boolean bl = firstIsColon = Util$.MODULE$.nodeChild((AstRuleCtx)ctx, 0).getSymbol().getType() == 46;
        if (firstIsColon && colons.size() > 1) {
            this._errors = (Seq)this._errors.$colon$plus((Object)this.exceptionFactory.syntaxException("Colon `:` conjunction is not allowed in INSERT. Use `CREATE` or conjunction with ampersand `&` instead.", this.inputPosition(((TerminalNode)colons.get(1)).getSymbol())));
            return;
        }
        if (!firstIsColon && colons.size() > 0) {
            this._errors = (Seq)this._errors.$colon$plus((Object)this.exceptionFactory.syntaxException("Colon `:` conjunction is not allowed in INSERT. Use `CREATE` or conjunction with ampersand `&` instead.", this.inputPosition(((TerminalNode)colons.get(0)).getSymbol())));
            return;
        }
    }

    private void checkFunctionInvocation(Cypher5Parser.FunctionInvocationContext ctx) {
        FunctionName functionName = (FunctionName)ctx.functionName().ast();
        String string = functionName.name();
        String string2 = "normalize";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            if (functionName.namespace().parts().isEmpty() && ctx.functionArgument().size() == 2) {
                this._errors = (Seq)this._errors.$colon$plus((Object)this.exceptionFactory.syntaxException("Invalid normal form, expected NFC, NFD, NFKC, NFKD", ((ASTNode)ctx.functionArgument(1).expression().ast()).position()));
                return;
            }
        }
    }

    private void checkTypePart(Cypher5Parser.TypePartContext ctx) {
        Object cypherType = ctx.typeName().ast;
        if (cypherType instanceof ClosedDynamicUnionType && ctx.typeNullability() != null) {
            this._errors = (Seq)this._errors.$colon$plus((Object)this.exceptionFactory.syntaxException("Closed Dynamic Union Types can not be appended with `NOT NULL`, specify `NOT NULL` on all inner types instead.", Util$.MODULE$.pos((ParserRuleContext)ctx.typeNullability())));
            return;
        }
    }

    private void checkHint(Cypher5Parser.HintContext ctx) {
        int n = Util$.MODULE$.nodeChild((AstRuleCtx)ctx, 1).getSymbol().getType();
        switch (n) {
            case 38: {
                this._errors = (Seq)this._errors.$colon$plus((Object)this.exceptionFactory.syntaxException(ASTExceptionFactory.invalidHintIndexType((HintIndexType)HintIndexType.BTREE), Util$.MODULE$.pos(Util$.MODULE$.nodeChild((AstRuleCtx)ctx, 1))));
                return;
            }
        }
    }

    private final void addError$1(Cypher5Parser.GlobPartContext ctx$1) {
        this._errors = (Seq)this._errors.$colon$plus((Object)this.exceptionFactory.syntaxException("Each part of the glob (a block of text up until a dot) must either be fully escaped or not escaped at all.", this.inputPosition(ctx$1.start)));
    }

    public static final /* synthetic */ void $anonfun$checkAlterDatabase$1(Cypher5SyntaxChecker $this, Set keySet$1, Cypher5Parser.AlterDatabaseContext ctx$2, IntRef i$1, String k) {
        if (keySet$1.contains((Object)k)) {
            $this._errors = (Seq)$this._errors.$colon$plus((Object)$this.exceptionFactory.syntaxException("Duplicate 'REMOVE OPTION " + k + "' clause", Util$.MODULE$.pos((ParserRuleContext)ctx$2.symbolicNameString(i$1.elem))));
            return;
        }
        keySet$1.addOne((Object)k);
        ++i$1.elem;
    }

    public static final /* synthetic */ void $anonfun$checkAlterDatabase$3(Cypher5SyntaxChecker $this, Set keySet$2, Cypher5Parser.AlterDatabaseContext ctx$2, IntRef i$2, String k) {
        if (keySet$2.contains((Object)k)) {
            $this._errors = (Seq)$this._errors.$colon$plus((Object)$this.exceptionFactory.syntaxException("Duplicate 'SET OPTION " + k + "' clause", Util$.MODULE$.pos((ParserRuleContext)ctx$2.alterDatabaseOption(i$2.elem))));
            return;
        }
        keySet$2.addOne((Object)k);
        ++i$2.elem;
    }

    public Cypher5SyntaxChecker(CypherExceptionFactory exceptionFactory) {
        this.exceptionFactory = exceptionFactory;
        this._errors = (Seq)package$.MODULE$.Seq().empty();
    }
}

